/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionutil;

import alluxio.shaded.client.software.amazon.ionIonException;
import alluxio.shaded.client.software.amazon.ionTimestamp;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JarInfo {
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final String BUILD_TIME_ATTRIBUTE = "Ion-Java-Build-Time";
    private static final String PROJECT_VERSION_ATTRIBUTE = "Ion-Java-Project-Version";
    private String ourProjectVersion;
    private ionTimestamp ourBuildTime;

    public JarInfo() throws ionIonException {
        Enumeration<URL> manifestUrls;
        try {
            manifestUrls = this.getClass().getClassLoader().getResources(MANIFEST_FILE);
        }
        catch (IOException e) {
            throw new ionIonException("Unable to load manifests.", e);
        }
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        while (manifestUrls.hasMoreElements()) {
            try {
                manifests.add(new Manifest(manifestUrls.nextElement().openStream()));
            }
            catch (IOException e) {}
        }
        this.loadBuildProperties(manifests);
    }

    JarInfo(List<Manifest> manifests) {
        this.loadBuildProperties(manifests);
    }

    public String getProjectVersion() {
        return this.ourProjectVersion;
    }

    public ionTimestamp getBuildTime() {
        return this.ourBuildTime;
    }

    private void loadBuildProperties(List<Manifest> manifests) throws ionIonException {
        boolean propertiesLoaded = false;
        for (Manifest manifest : manifests) {
            boolean success = this.tryLoadBuildProperties(manifest);
            if (success && propertiesLoaded) {
                throw new ionIonException("Found multiple manifests with ion-java version info on the classpath.");
            }
            propertiesLoaded |= success;
        }
        if (!propertiesLoaded) {
            throw new ionIonException("Unable to locate manifest with ion-java version info on the classpath.");
        }
    }

    private boolean tryLoadBuildProperties(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        String projectVersion = mainAttributes.getValue(PROJECT_VERSION_ATTRIBUTE);
        String time = mainAttributes.getValue(BUILD_TIME_ATTRIBUTE);
        if (projectVersion == null || time == null) {
            return false;
        }
        this.ourProjectVersion = projectVersion;
        try {
            this.ourBuildTime = ionTimestamp.valueOf(time);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }
}

