/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.net.impl;

import alluxio.shaded.client.io.vertx.core.VertxException;
import alluxio.shaded.client.io.vertx.core.net.*;

import java.security.cert.CertificateException;

/**
 * @author <a href="https://julien.ponge.alluxio.shaded.client.org.">Julien Ponge</a>
 */
public class SelfSignedCertificateImpl implements SelfSignedCertificate {

  private final alluxio.shaded.client.io.netty.handler.ssl.util.SelfSignedCertificate certificate;

  public SelfSignedCertificateImpl() {
    try {
      certificate = new alluxio.shaded.client.io.netty.handler.ssl.util.SelfSignedCertificate();
    } catch (CertificateException e) {
      throw new VertxException(e);
    }
  }

  public SelfSignedCertificateImpl(String fqdn) {
    try {
      certificate = new alluxio.shaded.client.io.netty.handler.ssl.util.SelfSignedCertificate(fqdn);
    } catch (CertificateException e) {
      throw new VertxException(e);
    }
  }

  @Override
  public PemKeyCertOptions keyCertOptions() {
    return new PemKeyCertOptions()
      .setKeyPath(privateKeyPath())
      .setCertPath(certificatePath());
  }

  @Override
  public PemTrustOptions trustOptions() {
    return new PemTrustOptions().addCertPath(certificatePath());
  }

  @Override
  public String privateKeyPath() {
    return certificate.privateKey().getAbsolutePath();
  }

  @Override
  public String certificatePath() {
    return certificate.certificate().getAbsolutePath();
  }

  @Override
  public void delete() {
    certificate.delete();
  }
}
