/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora.netty.event;

import alluxio.client.file.dora.netty.event.CancelledResponseEvent;
import alluxio.client.file.dora.netty.event.ChannelErrorResponseEvent;
import alluxio.client.file.dora.netty.event.DataResponseEvent;
import alluxio.client.file.dora.netty.event.EofResponseEvent;
import alluxio.client.file.dora.netty.event.ServerErrorResponseEvent;
import alluxio.client.file.dora.netty.event.UfsReadHeartBeatResponseEvent;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;

public class ResponseEventFactory {
    private static volatile ResponseEventFactory sResponseEventFactory = null;

    private ResponseEventFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResponseEventFactory getResponseEventFactory() {
        if (null != sResponseEventFactory) return sResponseEventFactory;
        Class<ResponseEventFactory> clazz = ResponseEventFactory.class;
        synchronized (ResponseEventFactory.class) {
            if (null != sResponseEventFactory) return sResponseEventFactory;
            sResponseEventFactory = new ResponseEventFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResponseEventFactory;
        }
    }

    public CancelledResponseEvent createCancelResponseEvent() {
        return new CancelledResponseEvent();
    }

    public DataResponseEvent createDataResponseEvent(DataBuffer dataBuffer) {
        Preconditions.checkState(dataBuffer.getNettyOutput() instanceof ByteBuf, "dataBuffer.getNettyOutput is not of type ByteBuf");
        ByteBuf data = (ByteBuf)dataBuffer.getNettyOutput();
        return new DataResponseEvent(data);
    }

    public EofResponseEvent createEofResponseEvent() {
        return new EofResponseEvent();
    }

    public UfsReadHeartBeatResponseEvent createUfsReadHeartBeatResponseEvent() {
        return new UfsReadHeartBeatResponseEvent();
    }

    public ServerErrorResponseEvent createServerErrorResponseEvent(AlluxioStatusException alluxioStatusException) {
        return new ServerErrorResponseEvent(alluxioStatusException);
    }

    public ChannelErrorResponseEvent createChannelErrorResponseEvent(Throwable cause) {
        return new ChannelErrorResponseEvent(cause);
    }
}

