/*
 * Decompiled with CFR 0.152.
 */
package alluxio.extensions;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionsClassLoader.class);
    private final DefaultClassLoader mDefaultClassloader;

    public ExtensionsClassLoader(URL[] urls, ClassLoader defaultClassLoader) {
        super(urls, (ClassLoader)null);
        this.mDefaultClassloader = new DefaultClassLoader(defaultClassLoader);
        LOG.debug("Created ExtensionsClassLoader with jars={}", (Object[])urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.mDefaultClassloader.findClass(name);
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return this.mDefaultClassloader.loadClass(name, resolve);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = super.getResources(name);
        if (!resources.hasMoreElements()) {
            LOG.debug("Falling back to default class loader for loading resource {}", (Object)name);
            return this.mDefaultClassloader.getResources(name);
        }
        return resources;
    }

    public void addPath(String path) throws MalformedURLException {
        URL url = Paths.get(path, new String[0]).toUri().toURL();
        this.addURL(url);
    }

    private static class DefaultClassLoader
    extends ClassLoader {
        public DefaultClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return super.loadClass(name);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

