/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.membership.DefaultServiceEntity;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.gson.Gson;
import alluxio.shaded.client.com.google.gson.GsonBuilder;
import alluxio.shaded.client.com.google.gson.InstanceCreator;
import alluxio.shaded.client.com.google.gson.annotations.Expose;
import alluxio.shaded.client.com.google.gson.annotations.SerializedName;
import alluxio.wire.WorkerIdentity;
import alluxio.wire.WorkerNetAddress;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;

public class WorkerServiceEntity
extends DefaultServiceEntity {
    @Expose
    @SerializedName(value="Identity")
    WorkerIdentity mIdentity;
    @Expose
    @SerializedName(value="WorkerNetAddress")
    WorkerNetAddress mAddress;
    @Expose
    @SerializedName(value="State")
    State mState = State.JOINED;
    @Expose
    @SerializedName(value="GenerationNumber")
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    int mGenerationNum = -1;

    public WorkerServiceEntity() {
    }

    public WorkerServiceEntity(WorkerIdentity identity, WorkerNetAddress addr) {
        super(identity.toString());
        this.mIdentity = identity;
        this.mAddress = addr;
        this.mState = State.AUTHORIZED;
    }

    public WorkerNetAddress getWorkerNetAddress() {
        return this.mAddress;
    }

    public WorkerIdentity getIdentity() {
        return this.mIdentity;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("WorkerId", this.mIdentity).add("WorkerAddr", this.mAddress.toString()).add("State", this.mState.toString()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerServiceEntity anotherO = (WorkerServiceEntity)o;
        return this.mIdentity.equals(anotherO.mIdentity) && this.getServiceEntityName().equals(anotherO.getServiceEntityName());
    }

    public int hashCode() {
        return Objects.hashCode(this.mIdentity, this.mServiceEntityName);
    }

    @Override
    public void deserialize(byte[] buf) {
        WorkerServiceEntity obj = this;
        InstanceCreator<DefaultServiceEntity> creator = type -> obj;
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter((Type)((Object)WorkerServiceEntity.class), creator).create();
        gson.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(buf)), WorkerServiceEntity.class);
    }

    static enum State {
        JOINED,
        AUTHORIZED,
        DECOMMISSIONED;

    }
}

