/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.SaslMessage;
import alluxio.security.authentication.SaslClientHandler;
import alluxio.shaded.client.com.google.common.util.concurrent.SettableFuture;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.javax.security.sasl.SaslException;
import alluxio.util.LogUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedChannelClientDriver
implements StreamObserver<SaslMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatedChannelClientDriver.class);
    private final GrpcChannelKey mChannelKey;
    private final SaslClientHandler mSaslClientHandler;
    private final SettableFuture<Void> mChannelAuthenticatedFuture;
    private final SaslMessage mInitiateMessage;
    private StreamObserver<SaslMessage> mRequestObserver;
    private volatile boolean mChannelAuthenticated;

    public AuthenticatedChannelClientDriver(SaslClientHandler saslClientHandler, GrpcChannelKey channelKey) throws SaslException {
        this.mSaslClientHandler = saslClientHandler;
        this.mChannelKey = channelKey;
        this.mChannelAuthenticated = false;
        this.mChannelAuthenticatedFuture = SettableFuture.create();
        this.mInitiateMessage = this.generateInitialMessage();
    }

    public void setServerObserver(StreamObserver<SaslMessage> requestObserver) {
        this.mRequestObserver = requestObserver;
    }

    @Override
    public void onNext(SaslMessage saslMessage) {
        try {
            LOG.debug("Received message for channel: {}. Message: {}", (Object)this.mChannelKey.toString(), (Object)saslMessage);
            SaslMessage response = this.mSaslClientHandler.handleMessage(saslMessage);
            if (response != null) {
                this.mRequestObserver.onNext(response);
            } else {
                LOG.debug("Authentication established for {}", (Object)this.mChannelKey);
                this.mChannelAuthenticatedFuture.set(null);
            }
        }
        catch (Throwable t) {
            LOG.debug("Exception while handling message for {}. Message: {}. Error: {}", new Object[]{this.mChannelKey.toString(), saslMessage, t});
            this.mChannelAuthenticatedFuture.setException(t);
            this.mRequestObserver.onError(AlluxioStatusException.fromThrowable(t).toGrpcStatusException());
        }
    }

    @Override
    public void onError(Throwable throwable) {
        LOG.debug("Authentication stream failed for client. Channel: {}. Error: {}", (Object)this.mChannelKey.toString(), (Object)throwable);
        this.closeAuthenticatedChannel(false);
        this.mChannelAuthenticatedFuture.setException(throwable);
    }

    @Override
    public void onCompleted() {
        LOG.debug("Authentication revoked by server. Channel: {}", (Object)this.mChannelKey.toString());
        this.closeAuthenticatedChannel(false);
    }

    public void close() {
        LOG.debug("Authentication client-driver closing. Channel: {}", (Object)this.mChannelKey.toString());
        this.closeAuthenticatedChannel(true);
    }

    public boolean isAuthenticated() {
        return this.mChannelAuthenticated;
    }

    public void startAuthenticatedChannel(long timeoutMs) throws AlluxioStatusException {
        try {
            LOG.debug("Initiating authentication for channel: {}", (Object)this.mChannelKey.toString());
            try {
                this.mRequestObserver.onNext(this.mInitiateMessage);
            }
            catch (StatusRuntimeException statusRuntimeException) {
                // empty catch block
            }
            this.waitUntilChannelAuthenticated(timeoutMs);
        }
        catch (Throwable t) {
            this.closeAuthenticatedChannel(true);
            throw AlluxioStatusException.fromThrowable(t);
        }
    }

    private SaslMessage generateInitialMessage() throws SaslException {
        SaslMessage.Builder initialMsg = this.mSaslClientHandler.handleMessage(null).toBuilder();
        initialMsg.setClientId(this.mChannelKey.getChannelId().toString());
        initialMsg.setChannelRef(this.mChannelKey.toString());
        return initialMsg.build();
    }

    private void waitUntilChannelAuthenticated(long timeoutMs) throws AlluxioStatusException {
        try {
            this.mChannelAuthenticatedFuture.get(timeoutMs, TimeUnit.MILLISECONDS);
            this.mChannelAuthenticated = true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw AlluxioStatusException.fromThrowable(ie);
        }
        catch (ExecutionException e) {
            AlluxioStatusException statExc = AlluxioStatusException.fromThrowable(e.getCause());
            if (statExc.getStatusCode() == Status.Code.UNIMPLEMENTED) {
                throw new UnauthenticatedException(String.format("Authentication is disabled on target server: %s.", this.mChannelKey));
            }
            throw statExc;
        }
        catch (TimeoutException e) {
            throw new UnavailableException(String.format("Failed to connect to remote server: %s.", this.mChannelKey), e);
        }
    }

    private void closeAuthenticatedChannel(boolean signalServer) {
        this.mSaslClientHandler.close();
        this.mChannelAuthenticated = false;
        if (signalServer) {
            try {
                this.mRequestObserver.onCompleted();
            }
            catch (Exception e) {
                LogUtils.warnWithException(LOG, "Failed signaling server for stream completion for channel: {}.", this.mChannelKey.toString(), e);
            }
        }
    }
}

