/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.CurrentUser;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.javax.security.auth.Subject;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AuthenticationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationUtils.class);

    @Nullable
    public static String getImpersonationUser(Subject subject, AlluxioConfiguration conf) {
        String hdfsUser = null;
        if (subject != null) {
            Set user = subject.getPrincipals(CurrentUser.class);
            LOG.debug("Impersonation: subject: {}", (Object)subject);
            if (!user.isEmpty()) {
                hdfsUser = ((CurrentUser)user.iterator().next()).getName();
            }
        }
        String impersonationUser = null;
        if (conf.isSet(PropertyKey.SECURITY_LOGIN_IMPERSONATION_USERNAME)) {
            impersonationUser = conf.getString(PropertyKey.SECURITY_LOGIN_IMPERSONATION_USERNAME);
            LOG.debug("Impersonation: configured: {}", (Object)impersonationUser);
            if ("_HDFS_USER_".equals(impersonationUser)) {
                impersonationUser = hdfsUser;
            } else {
                if (impersonationUser != null && !impersonationUser.isEmpty() && !"_NONE_".equals(impersonationUser)) {
                    LOG.warn("Impersonation ignored. Invalid configuration: {}", (Object)impersonationUser);
                }
                impersonationUser = null;
            }
            if (impersonationUser != null && impersonationUser.isEmpty()) {
                impersonationUser = null;
            }
        }
        LOG.debug("Impersonation: hdfsUser: {} impersonationUser: {}", hdfsUser, (Object)impersonationUser);
        return impersonationUser;
    }

    private AuthenticationUtils() {
    }
}

