/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.RuntimeConstants;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.base.Splitter;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.javax.security.sasl.AuthenticationException;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

@ThreadSafe
public final class ImpersonationAuthenticator {
    public static final String WILDCARD = "*";
    private static final Splitter SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private final Map<String, Set<String>> mImpersonationGroups = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> mImpersonationUsers = new HashMap<String, Set<String>>();
    private AlluxioConfiguration mConfiguration;

    public ImpersonationAuthenticator(AlluxioConfiguration conf) {
        this.mConfiguration = conf;
        for (PropertyKey key : conf.keySet()) {
            String value;
            String connectionUser;
            Matcher matcher = PropertyKey.Template.MASTER_IMPERSONATION_GROUPS_OPTION.match(key.getName());
            if (matcher.matches()) {
                connectionUser = matcher.group(1);
                value = conf.getOrDefault(key, null);
                if (connectionUser != null) {
                    this.mImpersonationGroups.put(connectionUser, Sets.newHashSet(SPLITTER.split(value)));
                }
            }
            if (!(matcher = PropertyKey.Template.MASTER_IMPERSONATION_USERS_OPTION.match(key.getName())).matches()) continue;
            connectionUser = matcher.group(1);
            value = conf.getOrDefault(key, null);
            if (connectionUser == null) continue;
            this.mImpersonationUsers.put(connectionUser, Sets.newHashSet(SPLITTER.split(value)));
        }
    }

    public void authenticate(String connectionUser, String impersonationUser) throws AuthenticationException {
        if (impersonationUser == null || connectionUser.equals(impersonationUser)) {
            return;
        }
        Set<String> allowedUsers = this.mImpersonationUsers.get(connectionUser);
        Set<String> allowedGroups = this.mImpersonationGroups.get(connectionUser);
        if (allowedUsers == null && allowedGroups == null) {
            throw new AuthenticationException(String.format("Failed to authenticate client user=\"%s\" connecting to Alluxio server and impersonating as impersonationUser=\"%s\" to access Alluxio file system. User \"%s\" is not configured to allow any impersonation. Please read the guide to configure impersonation at %s", connectionUser, impersonationUser, connectionUser, RuntimeConstants.ALLUXIO_SECURITY_DOCS_URL));
        }
        if (allowedUsers != null && (allowedUsers.contains(WILDCARD) || allowedUsers.contains(impersonationUser))) {
            return;
        }
        if (allowedGroups != null) {
            if (allowedGroups.contains(WILDCARD)) {
                return;
            }
            try {
                for (String impersonationGroup : CommonUtils.getGroups(impersonationUser, this.mConfiguration)) {
                    if (!allowedGroups.contains(impersonationGroup)) continue;
                    return;
                }
            }
            catch (IOException e) {
                throw new AuthenticationException(String.format("Failed to authenticate client user=\"%s\" connecting to Alluxio master and impersonating as impersonationUser=\"%s\" to access Alluxio file system: Failed to get groups that impersonationUser=\"%s\" belongs to.", connectionUser, impersonationUser, impersonationUser), (Throwable)e);
            }
        }
        throw new AuthenticationException(String.format("Failed to authenticate client user=\"%s\" connecting to Alluxio master and impersonating as impersonationUser=\"%s\" to access Alluxio file system. user=\"%s\" is not configured to impersonate as impersonationUser=\"%s\".Please read the guide to configure impersonation at %s", connectionUser, impersonationUser, connectionUser, impersonationUser, RuntimeConstants.ALLUXIO_SECURITY_DOCS_URL));
    }
}

