/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.login;

import alluxio.security.User;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.shaded.client.javax.security.auth.Subject;
import alluxio.shaded.client.javax.security.auth.callback.Callback;
import alluxio.shaded.client.javax.security.auth.callback.CallbackHandler;
import alluxio.shaded.client.javax.security.auth.callback.NameCallback;
import alluxio.shaded.client.javax.security.auth.callback.UnsupportedCallbackException;
import alluxio.shaded.client.javax.security.auth.login.LoginException;
import alluxio.shaded.client.javax.security.auth.spi.LoginModule;
import java.io.IOException;
import java.util.Map;

@NotThreadSafe
public final class AppLoginModule
implements LoginModule {
    private Subject mSubject;
    private User mUser;
    private CallbackHandler mCallbackHandler;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.mSubject = subject;
        this.mCallbackHandler = callbackHandler;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("user name: ")};
        try {
            this.mCallbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException | IOException e) {
            throw new LoginException(e.getMessage());
        }
        String userName = ((NameCallback)callbacks[0]).getName();
        if (!userName.isEmpty()) {
            this.mUser = new User(userName);
            return true;
        }
        return false;
    }

    public boolean abort() throws LoginException {
        this.logout();
        this.mUser = null;
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.mSubject.getPrincipals(User.class).isEmpty()) {
            return true;
        }
        if (this.mUser != null) {
            this.mSubject.getPrincipals().add(this.mUser);
            return true;
        }
        throw new LoginException("Cannot find a user");
    }

    public boolean logout() throws LoginException {
        if (this.mSubject.isReadOnly()) {
            throw new LoginException("logout Failed: Subject is Readonly.");
        }
        if (this.mUser != null) {
            this.mSubject.getPrincipals().remove(this.mUser);
        }
        return true;
    }

    @NotThreadSafe
    public static final class AppCallbackHandler
    implements CallbackHandler {
        private final String mUserName;

        public AppCallbackHandler(String username) {
            this.mUserName = username;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof NameCallback)) {
                    Class<?> callbackClass = callback == null ? null : callback.getClass();
                    throw new UnsupportedCallbackException(callback, callbackClass + " is unsupported.");
                }
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.mUserName);
            }
        }
    }
}

