/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.codahale.metrics.jmx;

import alluxio.shaded.client.com.codahale.metrics.jmx.JmxReporter;
import alluxio.shaded.client.com.codahale.metrics.jmx.ObjectNameFactory;
import alluxio.shaded.client.javax.management.MalformedObjectNameException;
import alluxio.shaded.client.javax.management.ObjectName;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObjectNameFactory
implements ObjectNameFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxReporter.class);

    @Override
    public ObjectName createName(String type, String domain, String name) {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("name", name);
            properties.put("type", type);
            ObjectName objectName = new ObjectName(domain, properties);
            if (objectName.isDomainPattern()) {
                domain = ObjectName.quote((String)domain);
            }
            if (objectName.isPropertyValuePattern("name")) {
                properties.put("name", ObjectName.quote((String)name));
            }
            if (objectName.isPropertyValuePattern("type")) {
                properties.put("type", ObjectName.quote((String)type));
            }
            objectName = new ObjectName(domain, properties);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote((String)name));
            }
            catch (MalformedObjectNameException e1) {
                LOGGER.warn("Unable to register {} {}", new Object[]{type, name, e1});
                throw new RuntimeException(e1);
            }
        }
    }
}

