/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.api.lock;

import alluxio.shaded.client.io.etcd.jetcd.api.lock.LockGrpc;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse;
import alluxio.shaded.client.io.grpc.BindableService;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.io.grpc.stub.AbstractStub;
import alluxio.shaded.client.io.grpc.stub.ServerCalls;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Vertx;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls;

public final class VertxLockGrpc {
    private static final int METHODID_LOCK = 0;
    private static final int METHODID_UNLOCK = 1;

    private VertxLockGrpc() {
    }

    public static LockVertxStub newVertxStub(Channel channel) {
        return new LockVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final LockVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(LockVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne((LockRequest)request, responseObserver, this.compression, this.serviceImpl::lock);
                    break;
                }
                case 1: {
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne((UnlockRequest)request, responseObserver, this.compression, this.serviceImpl::unlock);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class LockVertxImplBase
    implements BindableService {
        private String compression;

        public LockVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<LockResponse> lock(LockRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<UnlockResponse> unlock(UnlockRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(LockGrpc.getServiceDescriptor()).addMethod(LockGrpc.getLockMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(LockGrpc.getUnlockMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).build();
        }
    }

    public static final class LockVertxStub
    extends AbstractStub<LockVertxStub> {
        private final ContextInternal ctx;
        private LockGrpc.LockStub delegateStub;

        private LockVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = LockGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private LockVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = LockGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        @Override
        protected LockVertxStub build(Channel channel, CallOptions callOptions) {
            return new LockVertxStub(channel, callOptions);
        }

        public Future<LockResponse> lock(LockRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::lock);
        }

        public Future<UnlockResponse> unlock(UnlockRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::unlock);
        }
    }
}

