/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.netty;

import alluxio.shaded.client.io.grpc.netty.UnhelpfulSecurityProvider;
import alluxio.shaded.client.javax.net.ssl.KeyManager;
import alluxio.shaded.client.javax.net.ssl.KeyManagerFactory;
import alluxio.shaded.client.javax.net.ssl.KeyManagerFactorySpi;
import alluxio.shaded.client.javax.net.ssl.ManagerFactoryParameters;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class FixedKeyManagerFactory
extends KeyManagerFactory {
    public FixedKeyManagerFactory(List<KeyManager> keyManagers) {
        super((KeyManagerFactorySpi)new FixedKeyManagerFactorySpi(keyManagers), (Provider)new UnhelpfulSecurityProvider(), "FakeAlgorithm");
    }

    private static final class FixedKeyManagerFactorySpi
    extends KeyManagerFactorySpi {
        private final List<KeyManager> keyManagers;

        public FixedKeyManagerFactorySpi(List<KeyManager> keyManagers) {
            this.keyManagers = Collections.unmodifiableList(new ArrayList<KeyManager>(keyManagers));
        }

        protected KeyManager[] engineGetKeyManagers() {
            return this.keyManagers.toArray(new KeyManager[0]);
        }

        protected void engineInit(KeyStore ks, char[] password) {
        }

        protected void engineInit(ManagerFactoryParameters spec) {
        }
    }
}

