/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.netty.handler.codec.xml;

import alluxio.shaded.client.com.fasterxml.aalto.AsyncByteArrayFeeder;
import alluxio.shaded.client.com.fasterxml.aalto.AsyncXMLInputFactory;
import alluxio.shaded.client.com.fasterxml.aalto.AsyncXMLStreamReader;
import alluxio.shaded.client.com.fasterxml.aalto.stax.InputFactoryImpl;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.io.netty.handler.codec.ByteToMessageDecoder;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlAttribute;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlCdata;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlCharacters;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlComment;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlDTD;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlDocumentEnd;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlDocumentStart;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlElementEnd;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlElementStart;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlEntityReference;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlNamespace;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlProcessingInstruction;
import alluxio.shaded.client.io.netty.handler.codec.xml.XmlSpace;
import alluxio.shaded.client.javax.xml.stream.XMLStreamException;
import java.util.List;

public class XmlDecoder
extends ByteToMessageDecoder {
    private static final AsyncXMLInputFactory XML_INPUT_FACTORY = new InputFactoryImpl();
    private static final XmlDocumentEnd XML_DOCUMENT_END = XmlDocumentEnd.INSTANCE;
    private final AsyncXMLStreamReader<AsyncByteArrayFeeder> streamReader = XML_INPUT_FACTORY.createAsyncForByteArray();
    private final AsyncByteArrayFeeder streamFeeder = (AsyncByteArrayFeeder)this.streamReader.getInputFeeder();

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        byte[] buffer = new byte[in.readableBytes()];
        in.readBytes(buffer);
        try {
            this.streamFeeder.feedInput(buffer, 0, buffer.length);
        }
        catch (XMLStreamException exception) {
            in.skipBytes(in.readableBytes());
            throw exception;
        }
        while (!this.streamFeeder.needMoreInput()) {
            int type = this.streamReader.next();
            switch (type) {
                case 7: {
                    out.add(new XmlDocumentStart(this.streamReader.getEncoding(), this.streamReader.getVersion(), this.streamReader.isStandalone(), this.streamReader.getCharacterEncodingScheme()));
                    break;
                }
                case 8: {
                    out.add(XML_DOCUMENT_END);
                    break;
                }
                case 1: {
                    int x;
                    XmlElementStart elementStart = new XmlElementStart(this.streamReader.getLocalName(), this.streamReader.getName().getNamespaceURI(), this.streamReader.getPrefix());
                    for (x = 0; x < this.streamReader.getAttributeCount(); ++x) {
                        XmlAttribute attribute = new XmlAttribute(this.streamReader.getAttributeType(x), this.streamReader.getAttributeLocalName(x), this.streamReader.getAttributePrefix(x), this.streamReader.getAttributeNamespace(x), this.streamReader.getAttributeValue(x));
                        elementStart.attributes().add(attribute);
                    }
                    for (x = 0; x < this.streamReader.getNamespaceCount(); ++x) {
                        XmlNamespace namespace = new XmlNamespace(this.streamReader.getNamespacePrefix(x), this.streamReader.getNamespaceURI(x));
                        elementStart.namespaces().add(namespace);
                    }
                    out.add(elementStart);
                    break;
                }
                case 2: {
                    XmlElementEnd elementEnd = new XmlElementEnd(this.streamReader.getLocalName(), this.streamReader.getName().getNamespaceURI(), this.streamReader.getPrefix());
                    for (int x = 0; x < this.streamReader.getNamespaceCount(); ++x) {
                        XmlNamespace namespace = new XmlNamespace(this.streamReader.getNamespacePrefix(x), this.streamReader.getNamespaceURI(x));
                        elementEnd.namespaces().add(namespace);
                    }
                    out.add(elementEnd);
                    break;
                }
                case 3: {
                    out.add(new XmlProcessingInstruction(this.streamReader.getPIData(), this.streamReader.getPITarget()));
                    break;
                }
                case 4: {
                    out.add(new XmlCharacters(this.streamReader.getText()));
                    break;
                }
                case 5: {
                    out.add(new XmlComment(this.streamReader.getText()));
                    break;
                }
                case 6: {
                    out.add(new XmlSpace(this.streamReader.getText()));
                    break;
                }
                case 9: {
                    out.add(new XmlEntityReference(this.streamReader.getLocalName(), this.streamReader.getText()));
                    break;
                }
                case 11: {
                    out.add(new XmlDTD(this.streamReader.getText()));
                    break;
                }
                case 12: {
                    out.add(new XmlCdata(this.streamReader.getText()));
                }
            }
        }
    }
}

