/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.prometheus.metrics.config;

import alluxio.shaded.client.io.prometheus.metrics.config.PrometheusPropertiesException;
import alluxio.shaded.client.io.prometheus.metrics.config.Util;
import java.util.Map;

public class ExemplarsProperties {
    private static final String MIN_RETENTION_PERIOD_SECONDS = "minRetentionPeriodSeconds";
    private static final String MAX_RETENTION_PERIOD_SECONDS = "maxRetentionPeriodSeconds";
    private static final String SAMPLE_INTERVAL_MILLISECONDS = "sampleIntervalMilliseconds";
    private final Integer minRetentionPeriodSeconds;
    private final Integer maxRetentionPeriodSeconds;
    private final Integer sampleIntervalMilliseconds;

    private ExemplarsProperties(Integer minRetentionPeriodSeconds, Integer maxRetentionPeriodSeconds, Integer sampleIntervalMilliseconds) {
        this.minRetentionPeriodSeconds = minRetentionPeriodSeconds;
        this.maxRetentionPeriodSeconds = maxRetentionPeriodSeconds;
        this.sampleIntervalMilliseconds = sampleIntervalMilliseconds;
    }

    public Integer getMinRetentionPeriodSeconds() {
        return this.minRetentionPeriodSeconds;
    }

    public Integer getMaxRetentionPeriodSeconds() {
        return this.maxRetentionPeriodSeconds;
    }

    public Integer getSampleIntervalMilliseconds() {
        return this.sampleIntervalMilliseconds;
    }

    static ExemplarsProperties load(String prefix, Map<Object, Object> properties) throws PrometheusPropertiesException {
        Integer minRetentionPeriodSeconds = Util.loadInteger(prefix + "." + MIN_RETENTION_PERIOD_SECONDS, properties);
        Integer maxRetentionPeriodSeconds = Util.loadInteger(prefix + "." + MAX_RETENTION_PERIOD_SECONDS, properties);
        Integer sampleIntervalMilliseconds = Util.loadInteger(prefix + "." + SAMPLE_INTERVAL_MILLISECONDS, properties);
        Util.assertValue(minRetentionPeriodSeconds, t -> t > 0, "Expecting value > 0.", prefix, MIN_RETENTION_PERIOD_SECONDS);
        Util.assertValue(minRetentionPeriodSeconds, t -> t > 0, "Expecting value > 0.", prefix, MAX_RETENTION_PERIOD_SECONDS);
        Util.assertValue(sampleIntervalMilliseconds, t -> t > 0, "Expecting value > 0.", prefix, SAMPLE_INTERVAL_MILLISECONDS);
        if (minRetentionPeriodSeconds != null && maxRetentionPeriodSeconds != null && minRetentionPeriodSeconds > maxRetentionPeriodSeconds) {
            throw new PrometheusPropertiesException(prefix + "." + MIN_RETENTION_PERIOD_SECONDS + " must not be greater than " + prefix + "." + MAX_RETENTION_PERIOD_SECONDS + ".");
        }
        return new ExemplarsProperties(minRetentionPeriodSeconds, maxRetentionPeriodSeconds, sampleIntervalMilliseconds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer minRetentionPeriodSeconds;
        private Integer maxRetentionPeriodSeconds;
        private Integer sampleIntervalMilliseconds;

        private Builder() {
        }

        public Builder minRetentionPeriodSeconds(int minRetentionPeriodSeconds) {
            this.minRetentionPeriodSeconds = minRetentionPeriodSeconds;
            return this;
        }

        public Builder maxRetentionPeriodSeconds(int maxRetentionPeriodSeconds) {
            this.maxRetentionPeriodSeconds = maxRetentionPeriodSeconds;
            return this;
        }

        public Builder sampleIntervalMilliseconds(int sampleIntervalMilliseconds) {
            this.sampleIntervalMilliseconds = sampleIntervalMilliseconds;
            return this;
        }

        public ExemplarsProperties builder() {
            return new ExemplarsProperties(this.minRetentionPeriodSeconds, this.maxRetentionPeriodSeconds, this.sampleIntervalMilliseconds);
        }
    }
}

