/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.eventbus.impl.clustered;

import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.Promise;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.eventbus.EventBusOptions;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.codecs.PingMessageCodec;
import alluxio.shaded.client.io.vertx.core.impl.VertxInternal;
import alluxio.shaded.client.io.vertx.core.impl.logging.Logger;
import alluxio.shaded.client.io.vertx.core.impl.logging.LoggerFactory;
import alluxio.shaded.client.io.vertx.core.net.NetSocket;
import alluxio.shaded.client.io.vertx.core.net.impl.ConnectionBase;
import alluxio.shaded.client.io.vertx.core.spi.cluster.NodeInfo;
import alluxio.shaded.client.io.vertx.core.spi.metrics.EventBusMetrics;
import java.util.ArrayDeque;
import java.util.Queue;

class ConnectionHolder {
    private static final Logger log = LoggerFactory.getLogger(ConnectionHolder.class);
    private static final String PING_ADDRESS = "__vertx_ping";
    private final ClusteredEventBus eventBus;
    private final String remoteNodeId;
    private final VertxInternal vertx;
    private final EventBusMetrics metrics;
    private Queue<OutboundDeliveryContext<?>> pending;
    private NetSocket socket;
    private boolean connected;
    private long timeoutID = -1L;
    private long pingTimeoutID = -1L;

    ConnectionHolder(ClusteredEventBus eventBus, String remoteNodeId) {
        this.eventBus = eventBus;
        this.remoteNodeId = remoteNodeId;
        this.vertx = eventBus.vertx();
        this.metrics = eventBus.getMetrics();
    }

    void connect() {
        Promise<NodeInfo> promise = Promise.promise();
        this.eventBus.vertx().getClusterManager().getNodeInfo(this.remoteNodeId, promise);
        promise.future().flatMap(info -> this.eventBus.client().connect(info.port(), info.host())).onComplete(ar -> {
            if (ar.succeeded()) {
                this.connected((NetSocket)ar.result());
            } else {
                log.warn("Connecting to server " + this.remoteNodeId + " failed", ar.cause());
                this.close(ar.cause());
            }
        });
    }

    synchronized void writeMessage(OutboundDeliveryContext<?> ctx) {
        if (this.connected) {
            Buffer data = ((ClusteredMessage)ctx.message).encodeToWire();
            if (this.metrics != null) {
                this.metrics.messageWritten(ctx.message.address(), data.length());
            }
            this.socket.write(data, (Handler<AsyncResult<Void>>)ctx);
        } else {
            if (this.pending == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Not connected to server " + this.remoteNodeId + " - starting queuing");
                }
                this.pending = new ArrayDeque();
            }
            this.pending.add(ctx);
        }
    }

    void close() {
        this.close(ConnectionBase.CLOSED_EXCEPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Throwable cause) {
        if (this.timeoutID != -1L) {
            this.vertx.cancelTimer(this.timeoutID);
        }
        if (this.pingTimeoutID != -1L) {
            this.vertx.cancelTimer(this.pingTimeoutID);
        }
        ConnectionHolder connectionHolder = this;
        synchronized (connectionHolder) {
            if (this.pending != null) {
                OutboundDeliveryContext<?> msg;
                while ((msg = this.pending.poll()) != null) {
                    msg.written(cause);
                }
            }
        }
        if (this.eventBus.connections().remove(this.remoteNodeId, this) && log.isDebugEnabled()) {
            log.debug("Cluster connection closed for server " + this.remoteNodeId);
        }
    }

    private void schedulePing() {
        EventBusOptions options = this.eventBus.options();
        this.pingTimeoutID = this.vertx.setTimer(options.getClusterPingInterval(), id1 -> {
            this.timeoutID = this.vertx.setTimer(options.getClusterPingReplyInterval(), id2 -> {
                log.warn("No pong from server " + this.remoteNodeId + " - will consider it dead");
                this.close();
            });
            ClusteredMessage<String, String> pingMessage = new ClusteredMessage<String, String>(this.remoteNodeId, PING_ADDRESS, null, null, new PingMessageCodec(), true, this.eventBus);
            Buffer data = pingMessage.encodeToWire();
            this.socket.write(data);
        });
    }

    private synchronized void connected(NetSocket socket) {
        this.socket = socket;
        this.connected = true;
        socket.exceptionHandler(err -> this.close((Throwable)err));
        socket.closeHandler(v -> this.close());
        socket.handler(data -> {
            this.vertx.cancelTimer(this.timeoutID);
            this.schedulePing();
        });
        this.schedulePing();
        if (this.pending != null) {
            if (log.isDebugEnabled()) {
                log.debug("Draining the queue for server " + this.remoteNodeId);
            }
            for (OutboundDeliveryContext outboundDeliveryContext : this.pending) {
                Buffer data2 = ((ClusteredMessage)outboundDeliveryContext.message).encodeToWire();
                if (this.metrics != null) {
                    this.metrics.messageWritten(outboundDeliveryContext.message.address(), data2.length());
                }
                socket.write(data2, (Handler<AsyncResult<Void>>)outboundDeliveryContext);
            }
        }
        this.pending = null;
    }
}

