/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.http.impl;

import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.io.netty.channel.ChannelPromise;
import alluxio.shaded.client.io.netty.handler.codec.compression.CompressionOptions;
import alluxio.shaded.client.io.netty.handler.codec.http.DefaultHttpContent;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpContentCompressor;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpContentEncoder;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpHeaderNames;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpResponse;

final class HttpChunkContentCompressor
extends HttpContentCompressor {
    public HttpChunkContentCompressor(CompressionOptions ... compressionOptions) {
        super(0, compressionOptions);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buff;
        if (msg instanceof ByteBuf && (buff = (ByteBuf)msg).isReadable()) {
            msg = new DefaultHttpContent(buff);
        }
        super.write(ctx, msg, promise);
    }

    @Override
    protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
        HttpContentEncoder.Result result = super.beginEncode(httpResponse, acceptEncoding);
        if (result == null && httpResponse.headers().contains(HttpHeaderNames.CONTENT_ENCODING, (CharSequence)"identity", true)) {
            httpResponse.headers().remove(HttpHeaderNames.CONTENT_ENCODING);
        }
        return result;
    }
}

