/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.grpc;

import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.ServerCall;
import alluxio.shaded.client.io.grpc.ServerCallHandler;
import alluxio.shaded.client.io.grpc.ServerInterceptor;
import alluxio.shaded.client.io.vertx.core.Vertx;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.impl.logging.Logger;
import alluxio.shaded.client.io.vertx.core.impl.logging.LoggerFactory;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ContextServerInterceptor
implements ServerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextServerInterceptor.class);

    public abstract void bind(Metadata var1);

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata metadata, ServerCallHandler<ReqT, RespT> handler) {
        ContextInternal ctx = (ContextInternal)Vertx.currentContext();
        if (ctx == null) {
            LOGGER.warn("Attempt to set contextual data from a non Vert.x thread");
        } else {
            this.bind(metadata);
        }
        return handler.startCall(call, metadata);
    }

    public static <T> T get(String key) {
        ContextInternal ctx = (ContextInternal)Vertx.currentContext();
        if (ctx != null) {
            ConcurrentMap<String, T> contextDataMap = ContextServerInterceptor.contextualDataMap(ctx);
            return (T)contextDataMap.get(key);
        }
        return null;
    }

    public static <T> T getOrDefault(String key, T defaultValue) {
        ContextInternal ctx = (ContextInternal)Vertx.currentContext();
        if (ctx != null) {
            ConcurrentMap<String, T> contextDataMap = ContextServerInterceptor.contextualDataMap(ctx);
            return contextDataMap.getOrDefault(key, defaultValue);
        }
        return defaultValue;
    }

    private static <T> ConcurrentMap<String, T> contextualDataMap(ContextInternal ctx) {
        Objects.requireNonNull(ctx);
        return (ConcurrentMap)ctx.localContextData().computeIfAbsent(ContextServerInterceptor.class, k -> new ConcurrentHashMap());
    }

    public static <R, T> R put(String key, T value) {
        ContextInternal ctx = (ContextInternal)Vertx.currentContext();
        if (ctx != null) {
            return (R)ContextServerInterceptor.contextualDataMap((ContextInternal)Vertx.currentContext()).put(key, value);
        }
        throw new IllegalStateException("No Vert.x Context found");
    }
}

