/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.grpc.stub;

import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.streams.WriteStream;

public class GrpcWriteStream<T>
implements WriteStream<T> {
    private final StreamObserver<T> observer;
    private Handler<Throwable> errHandler;

    public GrpcWriteStream(StreamObserver<T> observer) {
        this.observer = observer;
        this.errHandler = observer::onError;
    }

    @Override
    public WriteStream<T> exceptionHandler(Handler<Throwable> hndlr) {
        this.errHandler = hndlr == null ? this.observer::onError : t -> {
            this.observer.onError((Throwable)t);
            hndlr.handle((Throwable)t);
        };
        return this;
    }

    @Override
    public Future<Void> write(T data) {
        try {
            this.observer.onNext(data);
        }
        catch (Throwable e) {
            return Future.failedFuture(e);
        }
        return Future.succeededFuture();
    }

    @Override
    public void write(T data, Handler<AsyncResult<Void>> hndlr) {
        try {
            this.observer.onNext(data);
        }
        catch (Throwable e) {
            hndlr.handle(Future.failedFuture(e));
            return;
        }
        hndlr.handle(Future.succeededFuture());
    }

    @Override
    public void end(Handler<AsyncResult<Void>> hndlr) {
        try {
            this.observer.onCompleted();
        }
        catch (Throwable e) {
            hndlr.handle(Future.failedFuture(e));
            return;
        }
        hndlr.handle(Future.succeededFuture());
    }

    @Override
    public WriteStream<T> setWriteQueueMaxSize(int i) {
        this.errHandler.handle(new UnsupportedOperationException());
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public WriteStream<T> drainHandler(Handler<Void> hndlr) {
        this.errHandler.handle(new UnsupportedOperationException());
        return this;
    }

    public StreamObserver<T> streamObserver() {
        return this.observer;
    }
}

