/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.util.SimpleRateLimiter;
import java.util.Optional;

public interface RateLimiter {
    public Optional<Long> acquire();

    public long getWaitTimeNanos(long var1);

    public static RateLimiter createRateLimiter(long permitsPerSecond) {
        if (permitsPerSecond <= 0L) {
            return new RateLimiter(){

                @Override
                public Optional<Long> acquire() {
                    return Optional.empty();
                }

                @Override
                public long getWaitTimeNanos(long permit) {
                    return 0L;
                }
            };
        }
        return new SimpleRateLimiter(permitsPerSecond);
    }
}

