/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.maintenance;

import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;

import alluxio.shaded.client.com.google.protobuf.ByteString;

public class SnapshotResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.SnapshotResponse> {

    public SnapshotResponse(alluxio.shaded.client.io.etcd.jetcd.api.SnapshotResponse response) {
        super(response, response.getHeader());
    }

    /**
     * Returns the remaining bytes.
     *
     * @return the remaining bytes.
     */
    public long getRemainingBytes() {
        return getResponse().getRemainingBytes();
    }

    /**
     * Returns the blob.
     *
     * @return the blob.
     */
    public ByteString getBlob() {
        return getResponse().getBlob();
    }
}
