/*
 * Copyright 2018 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.channel.unix;

import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.ByteBufAllocator;
import alluxio.shaded.client.io.netty.buffer.CompositeByteBuf;
import alluxio.shaded.client.io.netty.util.internal.UnstableApi;

@UnstableApi
public final class PreferredDirectByteBufAllocator implements ByteBufAllocator {
    private ByteBufAllocator allocator;

    public void updateAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public ByteBuf buffer() {
        return allocator.directBuffer();
    }

    @Override
    public ByteBuf buffer(int initialCapacity) {
        return allocator.directBuffer(initialCapacity);
    }

    @Override
    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return allocator.directBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public ByteBuf alluxio.shaded.client.io.uffer() {
        return allocator.directBuffer();
    }

    @Override
    public ByteBuf alluxio.shaded.client.io.uffer(int initialCapacity) {
        return allocator.directBuffer(initialCapacity);
    }

    @Override
    public ByteBuf alluxio.shaded.client.io.uffer(int initialCapacity, int maxCapacity) {
        return allocator.directBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public ByteBuf heapBuffer() {
        return allocator.heapBuffer();
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity) {
        return allocator.heapBuffer(initialCapacity);
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return allocator.heapBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public ByteBuf directBuffer() {
        return allocator.directBuffer();
    }

    @Override
    public ByteBuf directBuffer(int initialCapacity) {
        return allocator.directBuffer(initialCapacity);
    }

    @Override
    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return allocator.directBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public CompositeByteBuf alluxio.shaded.client.com.ositeBuffer() {
        return allocator.alluxio.shaded.client.com.ositeDirectBuffer();
    }

    @Override
    public CompositeByteBuf alluxio.shaded.client.com.ositeBuffer(int maxNumComponents) {
        return allocator.alluxio.shaded.client.com.ositeDirectBuffer(maxNumComponents);
    }

    @Override
    public CompositeByteBuf alluxio.shaded.client.com.ositeHeapBuffer() {
        return allocator.alluxio.shaded.client.com.ositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf alluxio.shaded.client.com.ositeHeapBuffer(int maxNumComponents) {
        return allocator.alluxio.shaded.client.com.ositeHeapBuffer(maxNumComponents);
    }

    @Override
    public CompositeByteBuf alluxio.shaded.client.com.ositeDirectBuffer() {
        return allocator.alluxio.shaded.client.com.ositeDirectBuffer();
    }

    @Override
    public CompositeByteBuf alluxio.shaded.client.com.ositeDirectBuffer(int maxNumComponents) {
        return allocator.alluxio.shaded.client.com.ositeDirectBuffer(maxNumComponents);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return allocator.isDirectBufferPooled();
    }

    @Override
    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        return allocator.calculateNewCapacity(minNewCapacity, maxCapacity);
    }
}
