/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileSystemContext;
import alluxio.resource.CloseableResource;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.BlockInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BlockStoreClient {
    private static final Logger LOG = LoggerFactory.getLogger(BlockStoreClient.class);
    private final FileSystemContext mContext;

    public static BlockStoreClient create(FileSystemContext context) {
        return new BlockStoreClient(context);
    }

    @VisibleForTesting
    BlockStoreClient(FileSystemContext context) {
        this.mContext = context;
    }

    public BlockInfo getInfo(long blockId) throws IOException {
        try (CloseableResource<BlockMasterClient> masterClientResource = this.mContext.acquireBlockMasterClientResource();){
            BlockInfo blockInfo = masterClientResource.get().getBlockInfo(blockId);
            return blockInfo;
        }
    }

    public long getCapacityBytes() throws IOException {
        try (CloseableResource<BlockMasterClient> blockMasterClientResource = this.mContext.acquireBlockMasterClientResource();){
            long l = blockMasterClientResource.get().getCapacityBytes();
            return l;
        }
    }

    public long getUsedBytes() throws IOException {
        try (CloseableResource<BlockMasterClient> blockMasterClientResource = this.mContext.acquireBlockMasterClientResource();){
            long l = blockMasterClientResource.get().getUsedBytes();
            return l;
        }
    }
}

