/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.membership.AlluxioEtcdClient;
import alluxio.membership.MembershipManager;
import alluxio.membership.WorkerClusterView;
import alluxio.membership.WorkerServiceEntity;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.gson.JsonParseException;
import alluxio.shaded.client.io.etcd.jetcd.KeyValue;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdMembershipManager
implements MembershipManager {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdMembershipManager.class);
    private final AlluxioConfiguration mConf;
    private AlluxioEtcdClient mAlluxioEtcdClient;
    private String mClusterName;
    private Supplier<String> mRingPathPrefix = CommonUtils.memoize(this::constructRingPathPrefix);

    public static EtcdMembershipManager create(AlluxioConfiguration conf) {
        return new EtcdMembershipManager(conf);
    }

    public EtcdMembershipManager(AlluxioConfiguration conf) {
        this(conf, AlluxioEtcdClient.getInstance(conf));
    }

    public EtcdMembershipManager(AlluxioConfiguration conf, AlluxioEtcdClient alluxioEtcdClient) {
        this.mConf = conf;
        this.mClusterName = conf.getString(PropertyKey.ALLUXIO_CLUSTER_NAME);
        this.mAlluxioEtcdClient = alluxioEtcdClient;
    }

    private String constructRingPathPrefix() {
        return String.format("/DHT/%s/AUTHORIZED/", this.mClusterName);
    }

    private String getRingPathPrefix() {
        return this.mRingPathPrefix.get();
    }

    @Override
    public void join(WorkerInfo workerInfo) throws IOException {
        LOG.info("Try joining on etcd for worker:{} ", (Object)workerInfo);
        WorkerServiceEntity entity = new WorkerServiceEntity(workerInfo.getIdentity(), workerInfo.getAddress());
        String pathOnRing = new StringBuffer().append(this.getRingPathPrefix()).append(entity.getServiceEntityName()).toString();
        byte[] existingEntityBytes = this.mAlluxioEtcdClient.getForPath(pathOnRing);
        byte[] serializedEntity = entity.serialize();
        if (existingEntityBytes != null) {
            if (!Arrays.equals(existingEntityBytes, serializedEntity)) {
                WorkerServiceEntity existingEntity = new WorkerServiceEntity();
                existingEntity.deserialize(existingEntityBytes);
                LOG.warn("Same worker entity found bearing same workerid:{},existing WorkerServiceEntity to be overwritten:{},maybe benign if pod restart in k8s env or same worker scheduled to restart on another machine in baremetal env.", (Object)workerInfo.getIdentity().toString(), (Object)existingEntity);
                this.mAlluxioEtcdClient.createForPath(pathOnRing, Optional.of(serializedEntity));
            }
        } else {
            this.mAlluxioEtcdClient.createForPath(pathOnRing, Optional.of(serializedEntity));
        }
        this.mAlluxioEtcdClient.mServiceDiscovery.registerAndStartSync(entity);
        LOG.info("Joined on etcd for worker:{} ", (Object)workerInfo);
    }

    @Override
    public WorkerClusterView getAllMembers() throws IOException {
        Iterable<WorkerInfo> workerInfoIterable = this.parseWorkersFromEtcdKvPairs(this.mAlluxioEtcdClient.getChildren(this.getRingPathPrefix())).map(w -> new WorkerInfo().setIdentity(w.getIdentity()).setAddress(w.getWorkerNetAddress()))::iterator;
        return new WorkerClusterView(workerInfoIterable);
    }

    @Override
    public WorkerClusterView getLiveMembers() throws IOException {
        Iterable<WorkerInfo> workerInfoIterable = this.parseWorkersFromEtcdKvPairs(this.mAlluxioEtcdClient.mServiceDiscovery.getAllLiveServices()).map(w -> new WorkerInfo().setIdentity(w.getIdentity()).setAddress(w.getWorkerNetAddress()))::iterator;
        return new WorkerClusterView(workerInfoIterable);
    }

    @Override
    public WorkerClusterView getFailedMembers() throws IOException {
        Set liveWorkerIds = this.parseWorkersFromEtcdKvPairs(this.mAlluxioEtcdClient.mServiceDiscovery.getAllLiveServices()).map(WorkerServiceEntity::getIdentity).collect(Collectors.toSet());
        Iterable<WorkerInfo> failedWorkerIterable = this.parseWorkersFromEtcdKvPairs(this.mAlluxioEtcdClient.getChildren(this.getRingPathPrefix())).filter(w -> !liveWorkerIds.contains(w.getIdentity())).map(w -> new WorkerInfo().setIdentity(w.getIdentity()).setAddress(w.getWorkerNetAddress()))::iterator;
        return new WorkerClusterView(failedWorkerIterable);
    }

    private Stream<WorkerServiceEntity> parseWorkersFromEtcdKvPairs(List<KeyValue> workerKvs) {
        return workerKvs.stream().map(this::parseWorkerServiceEntity).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<WorkerServiceEntity> parseWorkerServiceEntity(KeyValue etcdKvPair) {
        try {
            WorkerServiceEntity entity = new WorkerServiceEntity();
            entity.deserialize(etcdKvPair.getValue().getBytes());
            return Optional.of(entity);
        }
        catch (JsonParseException ex) {
            return Optional.empty();
        }
    }

    @Override
    @VisibleForTesting
    public String showAllMembers() {
        try {
            WorkerClusterView registeredWorkers = this.getAllMembers();
            WorkerClusterView liveWorkers = this.getLiveMembers();
            String printFormat = "%s\t%s\t%s%n";
            StringBuilder sb = new StringBuilder(String.format(printFormat, "WorkerId", "Address", "Status"));
            for (WorkerInfo entity : registeredWorkers) {
                String entryLine = String.format(printFormat, entity.getIdentity(), entity.getAddress().getHost() + ":" + entity.getAddress().getRpcPort(), liveWorkers.getWorkerById(entity.getIdentity()).isPresent() ? "ONLINE" : "OFFLINE");
                sb.append(entryLine);
            }
            return sb.toString();
        }
        catch (IOException ex) {
            return String.format("Exception happened:%s", ex.getMessage());
        }
    }

    @Override
    public void stopHeartBeat(WorkerInfo worker) throws IOException {
        WorkerServiceEntity entity = new WorkerServiceEntity(worker.getIdentity(), worker.getAddress());
        this.mAlluxioEtcdClient.mServiceDiscovery.unregisterService(entity.getServiceEntityName());
    }

    @Override
    public void decommission(WorkerInfo worker) throws IOException {
    }

    @Override
    public void close() throws Exception {
    }
}

