/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.rabbitmq.client.impl;

import alluxio.shaded.client.com.rabbitmq.client.Address;
import alluxio.shaded.client.com.rabbitmq.client.ConnectionFactory;
import alluxio.shaded.client.com.rabbitmq.client.SocketConfigurator;
import alluxio.shaded.client.com.rabbitmq.client.SslContextFactory;
import alluxio.shaded.client.com.rabbitmq.client.impl.AbstractFrameHandlerFactory;
import alluxio.shaded.client.com.rabbitmq.client.impl.FrameHandler;
import alluxio.shaded.client.com.rabbitmq.client.impl.SocketFrameHandler;
import alluxio.shaded.client.javax.net.SocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;

public class SocketFrameHandlerFactory
extends AbstractFrameHandlerFactory {
    private final SocketFactory socketFactory;
    private final ExecutorService shutdownExecutor;
    private final SslContextFactory sslContextFactory;

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory socketFactory, SocketConfigurator configurator, boolean ssl) {
        this(connectionTimeout, socketFactory, configurator, ssl, null);
    }

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory socketFactory, SocketConfigurator configurator, boolean ssl, ExecutorService shutdownExecutor) {
        this(connectionTimeout, socketFactory, configurator, ssl, shutdownExecutor, null);
    }

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory socketFactory, SocketConfigurator configurator, boolean ssl, ExecutorService shutdownExecutor, SslContextFactory sslContextFactory) {
        super(connectionTimeout, configurator, ssl);
        this.socketFactory = socketFactory;
        this.shutdownExecutor = shutdownExecutor;
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public FrameHandler create(Address addr, String connectionName) throws IOException {
        String hostName = addr.getHost();
        int portNumber = ConnectionFactory.portOrDefault(addr.getPort(), this.ssl);
        Socket socket = null;
        try {
            socket = this.createSocket(connectionName);
            this.configurator.configure(socket);
            socket.connect(new InetSocketAddress(hostName, portNumber), this.connectionTimeout);
            return this.create(socket);
        }
        catch (IOException ioe) {
            SocketFrameHandlerFactory.quietTrySocketClose(socket);
            throw ioe;
        }
    }

    protected Socket createSocket(String connectionName) throws IOException {
        if (this.socketFactory != null) {
            return this.socketFactory.createSocket();
        }
        if (this.ssl) {
            return this.sslContextFactory.create(connectionName).getSocketFactory().createSocket();
        }
        return SocketFactory.getDefault().createSocket();
    }

    public FrameHandler create(Socket sock) throws IOException {
        return new SocketFrameHandler(sock, this.shutdownExecutor);
    }

    private static void quietTrySocketClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

