/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core;

import alluxio.shaded.client.io.vertx.codegen.annotations.CacheReturn;
import alluxio.shaded.client.io.vertx.codegen.annotations.GenIgnore;
import alluxio.shaded.client.io.vertx.codegen.annotations.VertxGen;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.impl.NoStackTraceThrowable;
import alluxio.shaded.client.io.vertx.core.impl.future.PromiseImpl;

@VertxGen
public interface Promise<T>
extends Handler<AsyncResult<T>> {
    public static <T> Promise<T> promise() {
        return new PromiseImpl();
    }

    @Override
    @GenIgnore
    default public void handle(AsyncResult<T> asyncResult) {
        if (asyncResult.succeeded()) {
            this.complete(asyncResult.result());
        } else {
            this.fail(asyncResult.cause());
        }
    }

    default public void complete(T result) {
        if (!this.tryComplete(result)) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    default public void complete() {
        if (!this.tryComplete()) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    default public void fail(Throwable cause) {
        if (!this.tryFail(cause)) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    default public void fail(String message) {
        if (!this.tryFail(message)) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    public boolean tryComplete(T var1);

    default public boolean tryComplete() {
        return this.tryComplete(null);
    }

    public boolean tryFail(Throwable var1);

    default public boolean tryFail(String message) {
        return this.tryFail(new NoStackTraceThrowable(message));
    }

    @CacheReturn
    public Future<T> future();
}

