/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.eventbus.impl;

import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.Promise;
import alluxio.shaded.client.io.vertx.core.eventbus.DeliveryOptions;
import alluxio.shaded.client.io.vertx.core.eventbus.ReplyException;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.DeliveryContextBase;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.EventBusImpl;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.MessageImpl;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.MessageTagExtractor;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.ReplyHandler;
import alluxio.shaded.client.io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.spi.metrics.EventBusMetrics;
import alluxio.shaded.client.io.vertx.core.spi.tracing.SpanKind;
import alluxio.shaded.client.io.vertx.core.spi.tracing.TagExtractor;
import alluxio.shaded.client.io.vertx.core.spi.tracing.VertxTracer;
import alluxio.shaded.client.io.vertx.core.tracing.TracingPolicy;
import java.util.function.BiConsumer;

public class OutboundDeliveryContext<T>
extends DeliveryContextBase<T>
implements Handler<AsyncResult<Void>> {
    public final ContextInternal ctx;
    public final DeliveryOptions options;
    public final ReplyHandler<T> replyHandler;
    private final Promise<Void> writePromise;
    private boolean src;
    EventBusImpl bus;
    EventBusMetrics metrics;

    OutboundDeliveryContext(ContextInternal ctx, MessageImpl message, DeliveryOptions options, ReplyHandler<T> replyHandler, Promise<Void> writePromise) {
        super(message, message.bus.outboundInterceptors(), ctx);
        this.ctx = ctx;
        this.options = options;
        this.replyHandler = replyHandler;
        this.writePromise = writePromise;
    }

    @Override
    public void handle(AsyncResult<Void> event) {
        this.written(event.cause());
    }

    public void written(Throwable failure) {
        Object trace;
        VertxTracer tracer;
        if (this.metrics != null) {
            boolean remote = this.message instanceof ClusteredMessage && ((ClusteredMessage)this.message).isToWire();
            this.metrics.messageSent(this.message.address(), !this.message.send, !remote, remote);
        }
        if ((tracer = this.ctx.tracer()) != null && (trace = this.message.trace) != null && this.src) {
            if (this.replyHandler != null) {
                this.replyHandler.trace = this.message.trace;
            } else {
                tracer.receiveResponse(this.ctx, null, trace, failure, TagExtractor.empty());
            }
        }
        if (failure instanceof ReplyException && this.replyHandler != null) {
            this.replyHandler.fail((ReplyException)failure);
        }
        if (this.writePromise != null) {
            if (failure == null) {
                this.writePromise.complete();
            } else {
                this.writePromise.fail(failure);
            }
        }
    }

    @Override
    protected void execute() {
        VertxTracer tracer = this.ctx.tracer();
        if (tracer != null) {
            if (this.message.trace == null) {
                this.src = true;
                BiConsumer<String, String> biConsumer = (key, val) -> this.message.headers().set((String)key, (String)val);
                TracingPolicy tracingPolicy = this.options.getTracingPolicy();
                if (tracingPolicy == null) {
                    tracingPolicy = TracingPolicy.PROPAGATE;
                }
                this.message.trace = tracer.sendRequest(this.ctx, SpanKind.RPC, tracingPolicy, this.message, this.message.send ? "send" : "publish", biConsumer, MessageTagExtractor.INSTANCE);
            } else {
                tracer.sendResponse(this.ctx, null, this.message.trace, null, TagExtractor.empty());
            }
        }
        this.bus.sendOrPub(this);
    }

    @Override
    public boolean send() {
        return this.message.isSend();
    }

    @Override
    public Object body() {
        return this.message.sentBody;
    }
}

