/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.file.impl;

import alluxio.shaded.client.io.vertx.core.file.AsyncFile;
import alluxio.shaded.client.io.vertx.core.file.OpenOptions;
import alluxio.shaded.client.io.vertx.core.file.impl.AsyncFileImpl;
import alluxio.shaded.client.io.vertx.core.file.impl.FileSystemImpl;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.impl.VertxInternal;
import alluxio.shaded.client.io.vertx.core.impl.logging.Logger;
import alluxio.shaded.client.io.vertx.core.impl.logging.LoggerFactory;
import java.util.Objects;

public class WindowsFileSystem
extends FileSystemImpl {
    private static final Logger log = LoggerFactory.getLogger(WindowsFileSystem.class);

    public WindowsFileSystem(VertxInternal vertx) {
        super(vertx);
    }

    private static void logInternal(String perms) {
        if (perms != null && log.isDebugEnabled()) {
            log.debug("You are running on Windows and POSIX style file permissions are not supported");
        }
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> chmodInternal(String path, String perms, String dirPerms) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(perms);
        WindowsFileSystem.logInternal(perms);
        WindowsFileSystem.logInternal(dirPerms);
        if (log.isDebugEnabled()) {
            log.debug("You are running on Windows and POSIX style file permissions are not supported!");
        }
        return new FileSystemImpl.BlockingAction<Void>(){

            @Override
            public Void perform() {
                return null;
            }
        };
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> mkdirInternal(String path, String perms, boolean createParents) {
        WindowsFileSystem.logInternal(perms);
        return super.mkdirInternal(path, null, createParents);
    }

    @Override
    protected AsyncFile doOpen(String path, OpenOptions options, ContextInternal context) {
        WindowsFileSystem.logInternal(options.getPerms());
        return new AsyncFileImpl(this.vertx, path, options, context);
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> createFileInternal(String p, String perms) {
        WindowsFileSystem.logInternal(perms);
        return super.createFileInternal(p, null);
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> chownInternal(String path, String user, String group) {
        if (group != null && log.isDebugEnabled()) {
            log.debug("You are running on Windows and POSIX style file ownership is not supported");
        }
        return super.chownInternal(path, user, group);
    }
}

