/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.grpc;

import alluxio.shaded.client.io.grpc.BinaryLog;
import alluxio.shaded.client.io.grpc.BindableService;
import alluxio.shaded.client.io.grpc.CompressorRegistry;
import alluxio.shaded.client.io.grpc.DecompressorRegistry;
import alluxio.shaded.client.io.grpc.HandlerRegistry;
import alluxio.shaded.client.io.grpc.ServerBuilder;
import alluxio.shaded.client.io.grpc.ServerInterceptor;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import alluxio.shaded.client.io.grpc.ServerStreamTracer;
import alluxio.shaded.client.io.grpc.ServerTransportFilter;
import alluxio.shaded.client.io.grpc.netty.NettyServerBuilder;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.Vertx;
import alluxio.shaded.client.io.vertx.core.http.HttpServerOptions;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.impl.VertxInternal;
import alluxio.shaded.client.io.vertx.core.net.impl.ServerID;
import alluxio.shaded.client.io.vertx.grpc.VertxServer;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class VertxServerBuilder
extends ServerBuilder<VertxServerBuilder> {
    private final ServerID id;
    private final VertxInternal vertx;
    private final NettyServerBuilder builder;
    private final HttpServerOptions options = new HttpServerOptions();
    private Consumer<Runnable> commandDecorator;

    public static VertxServerBuilder forPort(Vertx vertx, int port) {
        return new VertxServerBuilder(vertx, port);
    }

    public static VertxServerBuilder forAddress(Vertx vertx, SocketAddress address) {
        return new VertxServerBuilder(vertx, address);
    }

    public static VertxServerBuilder forAddress(Vertx vertx, String host, int port) {
        return new VertxServerBuilder(vertx, new InetSocketAddress(host, port));
    }

    private VertxServerBuilder(Vertx vertx, int port) {
        this.id = new ServerID(port, "0.0.0.0");
        this.vertx = (VertxInternal)vertx;
        this.builder = NettyServerBuilder.forPort(port);
    }

    private VertxServerBuilder(Vertx vertx, SocketAddress address) {
        this.id = new ServerID(((InetSocketAddress)address).getPort(), ((InetSocketAddress)address).getHostString());
        this.vertx = (VertxInternal)vertx;
        this.builder = NettyServerBuilder.forAddress(address);
    }

    public NettyServerBuilder nettyBuilder() {
        return this.builder;
    }

    @Override
    public VertxServerBuilder directExecutor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertxServerBuilder executor(@Nullable Executor executor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertxServerBuilder addService(ServerServiceDefinition service) {
        this.builder.addService(service);
        return this;
    }

    @Override
    public VertxServerBuilder addService(BindableService bindableService) {
        this.builder.addService(bindableService);
        return this;
    }

    @Override
    public VertxServerBuilder fallbackHandlerRegistry(@Nullable HandlerRegistry fallbackRegistry) {
        this.builder.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    @Override
    public VertxServerBuilder useTransportSecurity(File certChain, File privateKey) {
        this.builder.useTransportSecurity(certChain, privateKey);
        return this;
    }

    @Override
    public VertxServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.builder.addTransportFilter(filter);
        return this;
    }

    @Override
    public VertxServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.builder.addStreamTracerFactory(factory);
        return this;
    }

    @Override
    public VertxServerBuilder decompressorRegistry(@Nullable DecompressorRegistry registry) {
        this.builder.decompressorRegistry(registry);
        return this;
    }

    @Override
    public VertxServerBuilder compressorRegistry(@Nullable CompressorRegistry registry) {
        this.builder.compressorRegistry(registry);
        return this;
    }

    @Override
    public VertxServerBuilder intercept(ServerInterceptor interceptor) {
        this.builder.intercept(interceptor);
        return this;
    }

    @Override
    public VertxServerBuilder useTransportSecurity(InputStream certChain, InputStream privateKey) {
        this.builder.useTransportSecurity(certChain, privateKey);
        return this;
    }

    @Override
    public VertxServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.builder.handshakeTimeout(timeout, unit);
        return this;
    }

    @Override
    public VertxServerBuilder maxInboundMessageSize(int bytes) {
        this.builder.maxInboundMessageSize(bytes);
        return this;
    }

    @Override
    public VertxServerBuilder setBinaryLog(BinaryLog binaryLog) {
        this.builder.setBinaryLog(binaryLog);
        return this;
    }

    @Override
    public VertxServerBuilder maxInboundMetadataSize(int bytes) {
        this.builder.maxInboundMetadataSize(bytes);
        return this;
    }

    public VertxServerBuilder useSsl(Handler<HttpServerOptions> handler) {
        handler.handle(this.options);
        return this;
    }

    public VertxServerBuilder commandDecorator(Consumer<Runnable> commandDecorator) {
        this.commandDecorator = commandDecorator;
        return this;
    }

    @Override
    public VertxServer build() {
        ContextInternal context = this.vertx.getOrCreateContext();
        return new VertxServer(this.id, this.options, this.builder, context, this.commandDecorator);
    }
}

