/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GetConfigHashPResponse;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;

@ThreadSafe
public class ConfigHash {
    private final String mClusterConfigHash;
    private final String mPathConfigHash;
    private long mClusterConfigLastUpdateTime;
    private long mPathConfigLastUpdateTime;

    public ConfigHash(String clusterConfigHash, String pathConfigHash, long clusterConfigLastUpdateTime, long pathConfigLastUpdateTime) {
        Preconditions.checkNotNull(clusterConfigHash, "clusterConfigHash");
        Preconditions.checkNotNull(pathConfigHash, "pathConfigHash");
        this.mClusterConfigHash = clusterConfigHash;
        this.mPathConfigHash = pathConfigHash;
        this.mClusterConfigLastUpdateTime = clusterConfigLastUpdateTime;
        this.mPathConfigLastUpdateTime = pathConfigLastUpdateTime;
    }

    private ConfigHash(GetConfigHashPResponse response) {
        this(response.getClusterConfigHash(), response.getPathConfigHash(), 0L, 0L);
    }

    public static ConfigHash fromProto(GetConfigHashPResponse response) {
        return new ConfigHash(response);
    }

    public GetConfigHashPResponse toProto() {
        GetConfigHashPResponse.Builder response = GetConfigHashPResponse.newBuilder();
        if (this.mClusterConfigHash != null) {
            response.setClusterConfigHash(this.mClusterConfigHash);
        }
        if (this.mPathConfigHash != null) {
            response.setPathConfigHash(this.mPathConfigHash);
        }
        return response.build();
    }

    public String getClusterConfigHash() {
        return this.mClusterConfigHash;
    }

    public String getPathConfigHash() {
        return this.mPathConfigHash;
    }

    public long getClusterConfigLastUpdateTime() {
        return this.mClusterConfigLastUpdateTime;
    }

    public long getPathConfigLastUpdateTime() {
        return this.mPathConfigLastUpdateTime;
    }

    public String getClusterConfigLastUpdateTimeText() {
        return CommonUtils.convertMsToDate(this.mClusterConfigLastUpdateTime, Configuration.getString(PropertyKey.USER_DATE_FORMAT_PATTERN));
    }

    public String getPathConfigLastUpdateTimeText() {
        return CommonUtils.convertMsToDate(this.mPathConfigLastUpdateTime, Configuration.getString(PropertyKey.USER_DATE_FORMAT_PATTERN));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigHash)) {
            return false;
        }
        ConfigHash that = (ConfigHash)o;
        return this.mClusterConfigHash.equals(that.mClusterConfigHash) && this.mPathConfigHash.equals(that.mPathConfigHash);
    }

    public int hashCode() {
        return Objects.hashCode(this.mClusterConfigHash, this.mPathConfigHash);
    }
}

