/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.com.google.common.hash.HashCode;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerIdentity;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

@VisibleForTesting
@ThreadSafe
public class KetamaHashProvider {
    private final int mReplicas;
    private final int mMaxAttempts;
    private final long mWorkerInfoUpdateIntervalNs;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();
    private final AtomicLong mLastUpdatedTimestamp = new AtomicLong(System.nanoTime());
    private final LongAdder mUpdateCount = new LongAdder();
    private final AtomicReference<Set<WorkerIdentity>> mLastWorkers = new AtomicReference(ImmutableSet.of());
    @Nullable
    private volatile SortedMap<Integer, WorkerIdentity> mActiveNodes;
    private final Object mInitLock = new Object();

    public KetamaHashProvider(int maxAttempts, long workerListTtlMs, int replicas) {
        this.mMaxAttempts = maxAttempts;
        this.mWorkerInfoUpdateIntervalNs = workerListTtlMs * 1000000L;
        this.mReplicas = replicas;
    }

    public List<WorkerIdentity> getMultiple(String key, int count) {
        LinkedHashSet<WorkerIdentity> workers = new LinkedHashSet<WorkerIdentity>();
        int attempts = 0;
        while (workers.size() < count && attempts < this.mMaxAttempts) {
            WorkerIdentity selectedWorker = this.get(key, ++attempts);
            workers.add(selectedWorker);
        }
        return ImmutableList.copyOf(workers);
    }

    public void refresh(Set<WorkerIdentity> workers) {
        Set<WorkerIdentity> lastWorkerIds;
        Preconditions.checkArgument(!workers.isEmpty(), "cannot refresh hash provider with empty worker list");
        this.maybeInitialize(workers);
        if (this.shouldRebuildActiveNodesMapExclusively() && !workers.equals(lastWorkerIds = this.mLastWorkers.get())) {
            this.updateActiveNodes(workers, this.mLastWorkers.get());
            this.mLastWorkers.set(workers);
            this.mUpdateCount.increment();
        }
    }

    private boolean shouldRebuildActiveNodesMapExclusively() {
        long lastUpdateTs = this.mLastUpdatedTimestamp.get();
        long currentTs = System.nanoTime();
        if (currentTs - lastUpdateTs > this.mWorkerInfoUpdateIntervalNs) {
            return this.mLastUpdatedTimestamp.compareAndSet(lastUpdateTs, currentTs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitialize(Set<WorkerIdentity> workers) {
        if (this.mActiveNodes == null) {
            Object object = this.mInitLock;
            synchronized (object) {
                if (this.mActiveNodes == null) {
                    this.build(workers);
                    this.mLastWorkers.set(workers);
                    this.mLastUpdatedTimestamp.set(System.nanoTime());
                }
            }
        }
    }

    private void updateActiveNodes(Set<WorkerIdentity> workers, Set<WorkerIdentity> lastWorkers) {
        HashSet<WorkerIdentity> workerSet = new HashSet<WorkerIdentity>(workers);
        HashSet<WorkerIdentity> lastWorkerSet = new HashSet<WorkerIdentity>(lastWorkers);
        for (WorkerIdentity worker : lastWorkerSet) {
            if (workerSet.contains(worker)) continue;
            this.remove(worker);
        }
        for (WorkerIdentity worker : workerSet) {
            if (lastWorkerSet.contains(worker)) continue;
            this.add(worker);
        }
    }

    @VisibleForTesting
    WorkerIdentity get(String key, int index) {
        Preconditions.checkState(this.mActiveNodes != null, "Hash provider is not properly initialized");
        if (this.mActiveNodes.isEmpty()) {
            return null;
        }
        int hash = this.hash(String.format("%s%d", key, index));
        if (!this.mActiveNodes.containsKey(hash)) {
            SortedMap<Integer, WorkerIdentity> tailMap = this.mActiveNodes.tailMap(hash);
            hash = tailMap.isEmpty() ? this.mActiveNodes.firstKey().intValue() : tailMap.firstKey().intValue();
        }
        return (WorkerIdentity)this.mActiveNodes.get(hash);
    }

    @VisibleForTesting
    Set<WorkerIdentity> getLastWorkers() {
        return this.mLastWorkers.get();
    }

    @VisibleForTesting
    SortedMap<Integer, WorkerIdentity> getActiveNodesMap() {
        return this.mActiveNodes;
    }

    @VisibleForTesting
    long getUpdateCount() {
        return this.mUpdateCount.sum();
    }

    @VisibleForTesting
    private void build(Set<WorkerIdentity> workers) {
        Preconditions.checkArgument(!workers.isEmpty(), "worker list is empty");
        this.mActiveNodes = new TreeMap<Integer, WorkerIdentity>();
        for (WorkerIdentity worker : workers) {
            this.add(worker);
        }
    }

    private void add(WorkerIdentity node) {
        Preconditions.checkState(this.mActiveNodes != null, "Hash provider is not properly initialized");
        HashCode hashCode = HASH_FUNCTION.newHasher().putObject(node, WorkerIdentity.HashFunnel.INSTANCE).hash();
        for (int i = 0; i < this.mReplicas; ++i) {
            this.mActiveNodes.put(hashCode.asInt() + i, node);
        }
    }

    private void remove(WorkerIdentity node) {
        Preconditions.checkState(this.mActiveNodes != null, "Hash provider is not properly initialized");
        HashCode hashCode = HASH_FUNCTION.newHasher().putObject(node, WorkerIdentity.HashFunnel.INSTANCE).hash();
        for (int i = 0; i < this.mReplicas; ++i) {
            this.mActiveNodes.remove(hashCode.asInt() + i);
        }
    }

    private int hash(String key) {
        return HASH_FUNCTION.hashString(key, StandardCharsets.UTF_8).asInt();
    }
}

