/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcChannelPool;
import alluxio.grpc.SaslAuthenticationServiceGrpc;
import alluxio.grpc.SaslMessage;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import alluxio.security.authentication.ChannelIdInjector;
import alluxio.security.authentication.SaslClientHandler;
import alluxio.security.authentication.plain.SaslClientHandlerPlain;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptor;
import alluxio.shaded.client.io.grpc.ClientInterceptors;
import alluxio.shaded.client.io.grpc.ForwardingClientCall;
import alluxio.shaded.client.io.grpc.ForwardingClientCallListener;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;

public class GrpcChannel
extends Channel
implements AutoCloseable {
    private static final long AUTH_TIMEOUT = Configuration.getMs(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT);
    private final GrpcChannelKey mChannelKey;
    private final ManagedChannel mManagedChannel;
    private final AtomicBoolean mChannelReleased = new AtomicBoolean(false);
    private final AtomicBoolean mChannelHealthy = new AtomicBoolean(true);
    private final AtomicReference<Channel> mChannel = new AtomicReference();
    private final AtomicReference<Optional<AuthenticatedChannelClientDriver>> mAuthDriver = new AtomicReference(Optional.empty());

    protected GrpcChannel(GrpcChannelKey channelKey, ManagedChannel managedChannel) {
        this.mChannelKey = Objects.requireNonNull(channelKey, "channelKey is null");
        this.mManagedChannel = Objects.requireNonNull(managedChannel, "managedChannel is null");
        this.mChannel.set(managedChannel);
    }

    public GrpcChannelKey getChannelKey() {
        return this.mChannelKey;
    }

    public Channel getChannel() {
        return this.mChannel.get();
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.mChannel.get().newCall(methodDescriptor, callOptions);
    }

    @Override
    public String authority() {
        return this.mChannel.get().authority();
    }

    protected SaslClientHandler createSaslClientHandler(AuthType authType, Subject subject, AlluxioConfiguration config) throws AlluxioStatusException {
        switch (authType) {
            case SIMPLE: 
            case CUSTOM: {
                return new SaslClientHandlerPlain(subject, config);
            }
            case NOSASL: {
                return null;
            }
        }
        throw new UnauthenticatedException(String.format("Channel authentication scheme not supported: %s", authType.name()));
    }

    protected void authenticate(AuthType authType, Subject subject, AlluxioConfiguration config) throws AlluxioStatusException {
        SaslClientHandler clientHandler = this.createSaslClientHandler(authType, subject, config);
        this.authenticate(authType, subject, config, clientHandler);
    }

    public void authenticate(AuthType authType, Subject subject, AlluxioConfiguration config, SaslClientHandler clientHandler) throws AlluxioStatusException {
        AuthenticatedChannelClientDriver authDriver;
        if (clientHandler == null) {
            return;
        }
        try {
            authDriver = new AuthenticatedChannelClientDriver(clientHandler, this.mChannelKey);
        }
        catch (SaslException t) {
            AlluxioStatusException e = AlluxioStatusException.fromThrowable(t);
            String message = String.format("Channel authentication failed with code:%s. Channel: %s, AuthType: %s, Error: %s", new Object[]{e.getStatusCode().name(), this.mManagedChannel, authType, e});
            throw AlluxioStatusException.from(Status.fromCode(e.getStatusCode()).withDescription(message).withCause(t));
        }
        SaslAuthenticationServiceGrpc.SaslAuthenticationServiceStub serverStub = SaslAuthenticationServiceGrpc.newStub(this.mManagedChannel);
        StreamObserver<SaslMessage> requestObserver = serverStub.authenticate(authDriver);
        authDriver.setServerObserver(requestObserver);
        authDriver.startAuthenticatedChannel(AUTH_TIMEOUT);
        this.mAuthDriver.set(Optional.of(authDriver));
        this.intercept(new ChannelIdInjector(this.mChannelKey.getChannelId()));
        this.intercept(new ClientInterceptor(){

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    @Override
                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            @Override
                            public void onClose(Status status, Metadata trailers) {
                                if (status == Status.UNAUTHENTICATED || status == Status.UNAVAILABLE) {
                                    GrpcChannel.this.mChannelHealthy.set(false);
                                }
                                super.onClose(status, trailers);
                            }
                        }, headers);
                    }
                };
            }
        });
    }

    public void intercept(ClientInterceptor interceptor) {
        Channel channel = this.mChannel.get();
        this.mChannel.compareAndSet(channel, ClientInterceptors.intercept(channel, interceptor));
    }

    public void shutdown() {
        Optional<AuthenticatedChannelClientDriver> authDriver = this.mAuthDriver.getAndSet(Optional.empty());
        authDriver.ifPresent(AuthenticatedChannelClientDriver::close);
        if (this.mChannelReleased.compareAndSet(false, true)) {
            try {
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to release the connection.", e);
            }
        }
    }

    public boolean isShutdown() {
        return this.mChannelReleased.get();
    }

    public boolean isHealthy() {
        return this.mChannelHealthy.get() && this.mAuthDriver.get().map(AuthenticatedChannelClientDriver::isAuthenticated).orElse(true) != false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GrpcChannel)) {
            return false;
        }
        GrpcChannel otherConnection = (GrpcChannel)other;
        return Objects.equals(this.mChannelKey, otherConnection.mChannelKey) && Objects.equals(this.mManagedChannel, otherConnection.mManagedChannel) && Objects.equals(this.mChannel.get(), otherConnection.mChannel.get()) && Objects.equals(this.mAuthDriver.get(), otherConnection.mAuthDriver.get());
    }

    public int hashCode() {
        return Objects.hash(this.mChannelKey, this.mManagedChannel, this.mAuthDriver.get(), this.mChannel.get());
    }

    @Override
    public void close() {
        GrpcChannelPool.INSTANCE.releaseConnection(this.mChannelKey);
    }
}

