/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.http;

import alluxio.shaded.client.com.amazonaws.AmazonWebServiceResponse;
import alluxio.shaded.client.com.amazonaws.ResponseMetadata;
import alluxio.shaded.client.com.amazonaws.http.HttpResponse;
import alluxio.shaded.client.com.amazonaws.http.HttpResponseHandler;
import alluxio.shaded.client.com.amazonaws.internal.SdkFilterInputStream;
import alluxio.shaded.client.com.amazonaws.transform.StaxUnmarshallerContext;
import alluxio.shaded.client.com.amazonaws.transform.Unmarshaller;
import alluxio.shaded.client.com.amazonaws.transform.VoidStaxUnmarshaller;
import alluxio.shaded.client.com.amazonaws.util.StringUtils;
import alluxio.shaded.client.com.amazonaws.util.XmlUtils;
import alluxio.shaded.client.javax.xml.stream.XMLEventReader;
import alluxio.shaded.client.javax.xml.stream.XMLStreamException;
import alluxio.shaded.client.org.apache.http.impl.io.EmptyInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaxResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"alluxio.shaded.client.com.amazonaws.request");

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        XMLEventReader eventReader;
        log.trace((Object)"Parsing service response XML");
        InputStream content = response.getContent();
        if (content == null) {
            content = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        } else if (content instanceof SdkFilterInputStream && ((SdkFilterInputStream)content).getDelegateStream() instanceof EmptyInputStream) {
            content = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        }
        try {
            eventReader = XmlUtils.getXmlInputFactory().createXMLEventReader(content);
        }
        catch (XMLStreamException e) {
            throw this.handleXmlStreamException(e);
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            awsResponse.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            Map<String, String> responseHeaders = response.getHeaders();
            if (responseHeaders != null) {
                if (responseHeaders.get("x-amzn-RequestId") != null) {
                    metadata.put("AWS_REQUEST_ID", responseHeaders.get("x-amzn-RequestId"));
                }
                if (responseHeaders.get("x-amz-id-2") != null) {
                    metadata.put("AWS_EXTENDED_REQUEST_ID", responseHeaders.get("x-amz-id-2"));
                }
            }
            awsResponse.setResponseMetadata(this.getResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        catch (XMLStreamException e) {
            throw this.handleXmlStreamException(e);
        }
        finally {
            try {
                eventReader.close();
            }
            catch (XMLStreamException e) {
                log.warn((Object)"Error closing xml parser", (Throwable)e);
            }
        }
    }

    private Exception handleXmlStreamException(XMLStreamException e) throws Exception {
        if (e.getNestedException() instanceof IOException) {
            return new IOException(e);
        }
        return e;
    }

    protected ResponseMetadata getResponseMetadata(Map<String, String> metadata) {
        return new ResponseMetadata(metadata);
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

