/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.com.google.common.cache.CacheBuilder;
import alluxio.shaded.client.com.google.common.cache.CacheLoader;
import alluxio.shaded.client.com.google.common.cache.LoadingCache;
import alluxio.shaded.client.com.google.common.collect.ImmutableMap;
import alluxio.shaded.client.com.google.common.collect.Maps;
import alluxio.shaded.client.com.google.inject.internal.Errors;
import alluxio.shaded.client.com.google.inject.internal.ErrorsException;
import java.util.Map;

public abstract class FailableCache<K, V> {
    private final LoadingCache<K, Object> delegate = CacheBuilder.newBuilder().build(new CacheLoader<K, Object>(){

        @Override
        public Object load(K key) {
            Errors errors = new Errors();
            Object result = null;
            try {
                result = FailableCache.this.create(key, errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
            return errors.hasErrors() ? errors : result;
        }
    });

    protected abstract V create(K var1, Errors var2) throws ErrorsException;

    public V get(K key, Errors errors) throws ErrorsException {
        Object resultOrError = this.delegate.getUnchecked(key);
        if (resultOrError instanceof Errors) {
            errors.merge((Errors)resultOrError);
            throw errors.toException();
        }
        Object result = resultOrError;
        return (V)result;
    }

    boolean remove(K key) {
        return this.delegate.asMap().remove(key) != null;
    }

    Map<K, V> asMap() {
        return Maps.transformValues(Maps.filterValues(ImmutableMap.copyOf(this.delegate.asMap()), resultOrError -> !(resultOrError instanceof Errors)), resultOrError -> {
            Object result = resultOrError;
            return result;
        });
    }
}

