/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm;

import alluxio.shaded.client.io.prometheus.metrics.config.PrometheusProperties;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmBufferPoolMetrics;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmClassLoadingMetrics;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmCompilationMetrics;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmGarbageCollectorMetrics;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmMemoryMetrics;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmMemoryPoolAllocationMetrics;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmRuntimeInfoMetric;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmThreadsMetrics;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.ProcessMetrics;
import alluxio.shaded.client.io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.util.concurrent.atomic.AtomicBoolean;

public class JvmMetrics {
    private static AtomicBoolean registeredWithTheDefaultRegistry = new AtomicBoolean(false);

    public static Builder builder() {
        return new Builder(PrometheusProperties.get());
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    public static class Builder {
        private final PrometheusProperties config;

        private Builder(PrometheusProperties config) {
            this.config = config;
        }

        public void register() {
            if (!registeredWithTheDefaultRegistry.getAndSet(true)) {
                this.register(PrometheusRegistry.defaultRegistry);
            }
        }

        public void register(PrometheusRegistry registry) {
            JvmThreadsMetrics.builder(this.config).register(registry);
            JvmBufferPoolMetrics.builder(this.config).register(registry);
            JvmClassLoadingMetrics.builder(this.config).register(registry);
            JvmCompilationMetrics.builder(this.config).register(registry);
            JvmGarbageCollectorMetrics.builder(this.config).register(registry);
            JvmMemoryPoolAllocationMetrics.builder(this.config).register(registry);
            JvmMemoryMetrics.builder(this.config).register(registry);
            JvmRuntimeInfoMetric.builder(this.config).register(registry);
            ProcessMetrics.builder(this.config).register(registry);
        }
    }
}

