/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.cli.converters;

import alluxio.shaded.client.io.vertx.core.cli.converters.BooleanConverter;
import alluxio.shaded.client.io.vertx.core.cli.converters.CharacterConverter;
import alluxio.shaded.client.io.vertx.core.cli.converters.ConstructorBasedConverter;
import alluxio.shaded.client.io.vertx.core.cli.converters.Converter;
import alluxio.shaded.client.io.vertx.core.cli.converters.FromBasedConverter;
import alluxio.shaded.client.io.vertx.core.cli.converters.FromStringBasedConverter;
import alluxio.shaded.client.io.vertx.core.cli.converters.ValueOfBasedConverter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class Converters {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Converter<?>> WELL_KNOWN_CONVERTERS;

    public static <T> T create(Class<T> type, String value) {
        if (type.isPrimitive()) {
            type = Converters.wrap(type);
        }
        return Converters.getConverter(type).fromString(value);
    }

    public static <T> T create(String value, Converter<T> converter) {
        return converter.fromString(value);
    }

    private static <T> Class<T> wrap(Class<T> type) {
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return wrapped == null ? type : wrapped;
    }

    private static <T> Converter<T> getConverter(Class<T> type) {
        if (WELL_KNOWN_CONVERTERS.containsKey(type)) {
            return WELL_KNOWN_CONVERTERS.get(type);
        }
        Converter<T> converter = ConstructorBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = ValueOfBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = FromBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = FromStringBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        throw new NoSuchElementException("Cannot find a converter able to create instance of " + type.getName());
    }

    public static <T> Converter<T> newInstance(Class<? extends Converter<T>> type) throws IllegalArgumentException {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create a new instance of " + type.getName() + " - it requires an public constructor without argument", e);
        }
    }

    static {
        HashMap<Class<Object>, Class<Void>> primToWrap = new HashMap<Class<Object>, Class<Void>>(16);
        primToWrap.put(Boolean.TYPE, Boolean.class);
        primToWrap.put(Byte.TYPE, Byte.class);
        primToWrap.put(Character.TYPE, Character.class);
        primToWrap.put(Double.TYPE, Double.class);
        primToWrap.put(Float.TYPE, Float.class);
        primToWrap.put(Integer.TYPE, Integer.class);
        primToWrap.put(Long.TYPE, Long.class);
        primToWrap.put(Short.TYPE, Short.class);
        primToWrap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        HashMap<Class<String>, Converter<Object>> wellKnown = new HashMap<Class<String>, Converter<Object>>(16);
        wellKnown.put(Boolean.class, BooleanConverter.INSTANCE);
        wellKnown.put(Byte.class, Byte::parseByte);
        wellKnown.put(Character.class, CharacterConverter.INSTANCE);
        wellKnown.put(Double.class, Double::parseDouble);
        wellKnown.put(Float.class, Float::parseFloat);
        wellKnown.put(Integer.class, Integer::parseInt);
        wellKnown.put(Long.class, Long::parseLong);
        wellKnown.put(Short.class, Short::parseShort);
        wellKnown.put(String.class, value -> value);
        WELL_KNOWN_CONVERTERS = Collections.unmodifiableMap(wellKnown);
    }
}

