package alluxio.shaded.client.io.etcd.jetcd.api;

import static alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getServiceDescriptor;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@alluxio.shaded.client.javax.annotation.Generated(
value = "by VertxGrpc generator",
alluxio.shaded.client.com.ents = "Source: rpc.proto")
public final class VertxAuthGrpc {
    private VertxAuthGrpc() {}

    public static AuthVertxStub newVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
        return new AuthVertxStub(channel);
    }

    
    public static final class AuthVertxStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<AuthVertxStub> {
        private final alluxio.shaded.client.io.vertx.core.impl.ContextInternal ctx;
        private AuthGrpc.AuthStub delegateStub;

        private AuthVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
            super(channel);
            delegateStub = AuthGrpc.newStub(channel);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        private AuthVertxStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = AuthGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected AuthVertxStub build(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            return new AuthVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableResponse> authEnable(alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::authEnable);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableResponse> authDisable(alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::authDisable);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateResponse> authenticate(alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::authenticate);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddResponse> userAdd(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userAdd);
        }

        /**
         * <pre>
         *  Compact alluxio.shaded.client.com.acts the event history in the etcd key-value store. The key-value
         *  store should be periodically alluxio.shaded.client.com.acted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetResponse> userGet(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userGet);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListResponse> userList(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userList);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteResponse> userDelete(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userDelete);
        }

        /**
         * <pre>
         *  UserChangePassword changes the password of a specified user.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordResponse> userChangePassword(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userChangePassword);
        }

        /**
         * <pre>
         *  UserGrant grants a role to a specified user.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleResponse> userGrantRole(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userGrantRole);
        }

        /**
         * <pre>
         *  UserRevokeRole revokes a role of specified user.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleResponse> userRevokeRole(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userRevokeRole);
        }

        /**
         * <pre>
         *  RoleAdd adds a new role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddResponse> roleAdd(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleAdd);
        }

        /**
         * <pre>
         *  RoleGet gets detailed role information.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetResponse> roleGet(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleGet);
        }

        /**
         * <pre>
         *  RoleList gets lists of all roles.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListResponse> roleList(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleList);
        }

        /**
         * <pre>
         *  RoleDelete deletes a specified role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteResponse> roleDelete(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleDelete);
        }

        /**
         * <pre>
         *  RoleGrantPermission grants a permission of a specified key or range to a specified role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionResponse> roleGrantPermission(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleGrantPermission);
        }

        /**
         * <pre>
         *  RoleRevokePermission revokes a key or range permission of a specified role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionResponse> roleRevokePermission(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleRevokePermission);
        }

    }

    
    public static abstract class AuthVertxImplBase implements alluxio.shaded.client.io.grpc.BindableService {
        private String alluxio.shaded.client.com.ression;

        /**
         * Set whether the server will try to use a alluxio.shaded.client.com.ressed response.
         *
         * @param alluxio.shaded.client.com.ression the alluxio.shaded.client.com.ression, e.g {@code gzip}
         */
        public AuthVertxImplBase withCompression(String alluxio.shaded.client.com.ression) {
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableResponse> authEnable(alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableResponse> authDisable(alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateResponse> authenticate(alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddResponse> userAdd(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Compact alluxio.shaded.client.com.acts the event history in the etcd key-value store. The key-value
         *  store should be periodically alluxio.shaded.client.com.acted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetResponse> userGet(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListResponse> userList(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteResponse> userDelete(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  UserChangePassword changes the password of a specified user.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordResponse> userChangePassword(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  UserGrant grants a role to a specified user.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleResponse> userGrantRole(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  UserRevokeRole revokes a role of specified user.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleResponse> userRevokeRole(alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleAdd adds a new role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddResponse> roleAdd(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleGet gets detailed role information.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetResponse> roleGet(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleList gets lists of all roles.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListResponse> roleList(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleDelete deletes a specified role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteResponse> roleDelete(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleGrantPermission grants a permission of a specified key or range to a specified role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionResponse> roleGrantPermission(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleRevokePermission revokes a key or range permission of a specified role.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionResponse> roleRevokePermission(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
            return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getAuthEnableMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableResponse>(
                                            this, METHODID_AUTH_ENABLE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getAuthDisableMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableResponse>(
                                            this, METHODID_AUTH_DISABLE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getAuthenticateMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateResponse>(
                                            this, METHODID_AUTHENTICATE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getUserAddMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddResponse>(
                                            this, METHODID_USER_ADD, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getUserGetMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetResponse>(
                                            this, METHODID_USER_GET, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getUserListMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListResponse>(
                                            this, METHODID_USER_LIST, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getUserDeleteMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteResponse>(
                                            this, METHODID_USER_DELETE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getUserChangePasswordMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordResponse>(
                                            this, METHODID_USER_CHANGE_PASSWORD, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getUserGrantRoleMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleResponse>(
                                            this, METHODID_USER_GRANT_ROLE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getUserRevokeRoleMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleResponse>(
                                            this, METHODID_USER_REVOKE_ROLE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getRoleAddMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddResponse>(
                                            this, METHODID_ROLE_ADD, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getRoleGetMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetResponse>(
                                            this, METHODID_ROLE_GET, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getRoleListMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListResponse>(
                                            this, METHODID_ROLE_LIST, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getRoleDeleteMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteResponse>(
                                            this, METHODID_ROLE_DELETE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getRoleGrantPermissionMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionResponse>(
                                            this, METHODID_ROLE_GRANT_PERMISSION, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.AuthGrpc.getRoleRevokePermissionMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionResponse>(
                                            this, METHODID_ROLE_REVOKE_PERMISSION, alluxio.shaded.client.com.ression)))
                    .build();
        }
    }

    private static final int METHODID_AUTH_ENABLE = 0;
    private static final int METHODID_AUTH_DISABLE = 1;
    private static final int METHODID_AUTHENTICATE = 2;
    private static final int METHODID_USER_ADD = 3;
    private static final int METHODID_USER_GET = 4;
    private static final int METHODID_USER_LIST = 5;
    private static final int METHODID_USER_DELETE = 6;
    private static final int METHODID_USER_CHANGE_PASSWORD = 7;
    private static final int METHODID_USER_GRANT_ROLE = 8;
    private static final int METHODID_USER_REVOKE_ROLE = 9;
    private static final int METHODID_ROLE_ADD = 10;
    private static final int METHODID_ROLE_GET = 11;
    private static final int METHODID_ROLE_LIST = 12;
    private static final int METHODID_ROLE_DELETE = 13;
    private static final int METHODID_ROLE_GRANT_PERMISSION = 14;
    private static final int METHODID_ROLE_REVOKE_PERMISSION = 15;

    private static final class MethodHandlers<Req, Resp> implements
            alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final AuthVertxImplBase serviceImpl;
        private final int methodId;
        private final String alluxio.shaded.client.com.ression;

        MethodHandlers(AuthVertxImplBase serviceImpl, int methodId, String alluxio.shaded.client.com.ression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_AUTH_ENABLE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::authEnable);
                    break;
                case METHODID_AUTH_DISABLE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::authDisable);
                    break;
                case METHODID_AUTHENTICATE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthenticateResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::authenticate);
                    break;
                case METHODID_USER_ADD:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::userAdd);
                    break;
                case METHODID_USER_GET:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::userGet);
                    break;
                case METHODID_USER_LIST:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::userList);
                    break;
                case METHODID_USER_DELETE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::userDelete);
                    break;
                case METHODID_USER_CHANGE_PASSWORD:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::userChangePassword);
                    break;
                case METHODID_USER_GRANT_ROLE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::userGrantRole);
                    break;
                case METHODID_USER_REVOKE_ROLE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::userRevokeRole);
                    break;
                case METHODID_ROLE_ADD:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::roleAdd);
                    break;
                case METHODID_ROLE_GET:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::roleGet);
                    break;
                case METHODID_ROLE_LIST:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::roleList);
                    break;
                case METHODID_ROLE_DELETE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::roleDelete);
                    break;
                case METHODID_ROLE_GRANT_PERMISSION:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::roleGrantPermission);
                    break;
                case METHODID_ROLE_REVOKE_PERMISSION:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::roleRevokePermission);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
