/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.org.apache.zookeeper.server.alluxio.shaded.client.com.and;

import java.alluxio.shaded.client.io.PrintWriter;

import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxn;
import alluxio.shaded.client.org.apache.zookeeper.server.ServerStats;
import alluxio.shaded.client.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;

public class StatResetCommand extends AbstractFourLetterCommand {
    public StatResetCommand(PrintWriter pw, ServerCnxn serverCnxn) {
        super(pw, serverCnxn);
    }

    @Override
    public void alluxio.shaded.client.com.andRun() {
        if (!isZKServerRunning()) {
            pw.println(ZK_NOT_SERVING);
        } else {
            ServerStats serverStats = zkServer.serverStats();
            serverStats.reset();
            if (serverStats.getServerState().equals("leader")) {
                ((LeaderZooKeeperServer)zkServer).getLeader().getProposalStats().reset();
            }
            pw.println("Server stats reset.");
        }
    }
}
