/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client;

import alluxio.client.AlluxioStorageType;
import alluxio.grpc.ReadPType;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public enum ReadType {
    NO_CACHE(1),
    CACHE(2),
    CACHE_PROMOTE(3);

    private final int mValue;

    private ReadType(int value) {
        this.mValue = value;
    }

    public AlluxioStorageType getAlluxioStorageType() {
        if (this.isPromote()) {
            return AlluxioStorageType.PROMOTE;
        }
        if (this.isCache()) {
            return AlluxioStorageType.STORE;
        }
        return AlluxioStorageType.NO_STORE;
    }

    public int getValue() {
        return this.mValue;
    }

    public boolean isCache() {
        return this.mValue == ReadType.CACHE.mValue || this.mValue == ReadType.CACHE_PROMOTE.mValue;
    }

    public boolean isPromote() {
        return this.mValue == ReadType.CACHE_PROMOTE.mValue;
    }

    public static ReadType fromProto(ReadPType readPType) {
        return ReadType.values()[readPType.getNumber() - 1];
    }

    public ReadPType toProto() {
        return ReadPType.values()[this.mValue - 1];
    }

    public static ReadType fromString(String text) {
        for (ReadType type : ReadType.values()) {
            if (!type.toString().equalsIgnoreCase(text)) continue;
            return type;
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }
}

