/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.CloseableSupplier;
import alluxio.PositionReader;
import alluxio.client.file.dora.netty.PartialReadException;
import alluxio.file.ReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.codahale.metrics.Meter;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DoraCachePositionReader
implements PositionReader {
    private static final Logger LOG = LoggerFactory.getLogger(DoraCachePositionReader.class);
    private final PositionReader mNettyReader;
    private final long mFileLength;
    private final Optional<CloseableSupplier<PositionReader>> mFallbackReader;
    private volatile boolean mClosed;

    public DoraCachePositionReader(PositionReader dataReader, long length, Optional<CloseableSupplier<PositionReader>> fallbackReader) {
        this.mNettyReader = dataReader;
        this.mFileLength = length;
        this.mFallbackReader = fallbackReader;
    }

    @Override
    public int readInternal(long position, ReadTargetBuffer buffer, int length) throws IOException {
        if (position >= this.mFileLength) {
            return -1;
        }
        int originalOffset = buffer.offset();
        try {
            return this.mNettyReader.read(position, buffer, length);
        }
        catch (PartialReadException e) {
            int bytesRead = e.getBytesRead();
            if (bytesRead == 0) {
                LOG.debug("Failed to read file from worker through Netty", (Throwable)e);
                buffer.offset(originalOffset);
                if (this.mFallbackReader.isPresent()) {
                    return DoraCachePositionReader.fallback((PositionReader)this.mFallbackReader.get().get(), position, buffer, length);
                }
                throw e;
            }
            buffer.offset(originalOffset + bytesRead);
            return bytesRead;
        }
        catch (Throwable t) {
            LOG.debug("Failed to read file from worker through Netty", t);
            buffer.offset(originalOffset);
            if (this.mFallbackReader.isPresent()) {
                return DoraCachePositionReader.fallback((PositionReader)this.mFallbackReader.get().get(), position, buffer, length);
            }
            throw t;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mNettyReader.close();
        if (this.mFallbackReader.isPresent()) {
            this.mFallbackReader.get().close();
        }
    }

    private static int fallback(PositionReader fallbackReader, long position, ReadTargetBuffer buffer, int length) throws IOException {
        int read = fallbackReader.read(position, buffer, length);
        Metrics.UFS_FALLBACK_READ_BYTES.mark(read);
        Metrics.UFS_FALLBACK_COUNT.inc();
        return read;
    }

    private static class Metrics {
        static final Counter UFS_FALLBACK_COUNT = MetricsSystem.counter(MetricKey.CLIENT_UFS_FALLBACK_COUNT.getName());
        static final Meter UFS_FALLBACK_READ_BYTES = MetricsSystem.meter(MetricKey.CLIENT_UFS_FALLBACK_READ_BYTES.getName());

        private Metrics() {
        }
    }
}

