/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.group;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.group.CachedGroupMapping;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GroupMappingService {
    public List<String> getGroups(String var1) throws IOException;

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        protected static volatile CachedGroupMapping sCachedGroupMapping = null;

        protected Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static GroupMappingService get(AlluxioConfiguration conf) {
            if (sCachedGroupMapping != null) return sCachedGroupMapping;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (sCachedGroupMapping != null) return sCachedGroupMapping;
                LOG.debug("Creating new Groups object");
                GroupMappingService groupMappingService = (GroupMappingService)CommonUtils.createNewClassInstance(conf.getClass(PropertyKey.SECURITY_GROUP_MAPPING_CLASS), null, null);
                sCachedGroupMapping = new CachedGroupMapping(groupMappingService, conf.getMs(PropertyKey.SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sCachedGroupMapping;
            }
        }
    }
}

