/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.metrics;

import alluxio.shaded.client.com.amazonaws.metrics.AwsSdkMetrics;
import alluxio.shaded.client.com.amazonaws.metrics.ByteThroughputProvider;
import alluxio.shaded.client.com.amazonaws.metrics.ServiceMetricCollector;
import alluxio.shaded.client.com.amazonaws.metrics.ThroughputMetricType;
import java.util.concurrent.TimeUnit;

class ByteThroughputHelper
extends ByteThroughputProvider {
    private static final int REPORT_INTERVAL_SECS = 10;

    ByteThroughputHelper(ThroughputMetricType type) {
        super(type);
    }

    long startTiming() {
        if (TimeUnit.NANOSECONDS.toSeconds(this.getDurationNano()) > 10L) {
            this.reportMetrics();
        }
        return System.nanoTime();
    }

    void reportMetrics() {
        if (this.getByteCount() > 0) {
            Object col = AwsSdkMetrics.getServiceMetricCollector();
            ((ServiceMetricCollector)col).collectByteThroughput(this);
            this.reset();
        }
    }

    @Override
    public void increment(int bytesDelta, long startTimeNano) {
        super.increment(bytesDelta, startTimeNano);
    }
}

