/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.github.oxo42.stateless4j;

import alluxio.shaded.client.com.github.oxo42.stateless4j.StateConfiguration;
import alluxio.shaded.client.com.github.oxo42.stateless4j.StateRepresentation;
import alluxio.shaded.client.com.github.oxo42.stateless4j.delegates.Func2;
import alluxio.shaded.client.com.github.oxo42.stateless4j.transitions.TransitioningTriggerBehaviour;
import alluxio.shaded.client.com.github.oxo42.stateless4j.triggers.TriggerBehaviour;
import alluxio.shaded.client.com.github.oxo42.stateless4j.triggers.TriggerWithParameters;
import alluxio.shaded.client.com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import alluxio.shaded.client.com.github.oxo42.stateless4j.triggers.TriggerWithParameters2;
import alluxio.shaded.client.com.github.oxo42.stateless4j.triggers.TriggerWithParameters3;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateMachineConfig<TState, TTrigger> {
    private final Map<TState, StateRepresentation<TState, TTrigger>> stateConfiguration = new HashMap<TState, StateRepresentation<TState, TTrigger>>();
    private final Map<TTrigger, TriggerWithParameters<TTrigger>> triggerConfiguration = new HashMap<TTrigger, TriggerWithParameters<TTrigger>>();

    public StateRepresentation<TState, TTrigger> getRepresentation(TState state) {
        return this.stateConfiguration.get(state);
    }

    private StateRepresentation<TState, TTrigger> getOrCreateRepresentation(TState state) {
        StateRepresentation<TState, Object> result = this.stateConfiguration.get(state);
        if (result == null) {
            result = new StateRepresentation(state);
            this.stateConfiguration.put(state, result);
        }
        return result;
    }

    public TriggerWithParameters<TTrigger> getTriggerConfiguration(TTrigger trigger) {
        return this.triggerConfiguration.get(trigger);
    }

    public boolean isTriggerConfigured(TTrigger trigger) {
        return this.triggerConfiguration.containsKey(trigger);
    }

    public StateConfiguration<TState, TTrigger> configure(TState state) {
        return new StateConfiguration<TState, TTrigger>(this.getOrCreateRepresentation(state), new Func2<TState, StateRepresentation<TState, TTrigger>>(){

            @Override
            public StateRepresentation<TState, TTrigger> call(TState arg0) {
                return StateMachineConfig.this.getOrCreateRepresentation(arg0);
            }
        });
    }

    private void saveTriggerConfiguration(TriggerWithParameters<TTrigger> trigger) {
        if (this.triggerConfiguration.containsKey(trigger.getTrigger())) {
            throw new IllegalStateException("Parameters for the trigger '" + trigger + "' have already been configured.");
        }
        this.triggerConfiguration.put(trigger.getTrigger(), trigger);
    }

    public <TArg0> TriggerWithParameters1<TArg0, TTrigger> setTriggerParameters(TTrigger trigger, Class<TArg0> classe0) {
        TriggerWithParameters1<TArg0, TTrigger> configuration = new TriggerWithParameters1<TArg0, TTrigger>(trigger, classe0);
        this.saveTriggerConfiguration(configuration);
        return configuration;
    }

    public <TArg0, TArg1> TriggerWithParameters2<TArg0, TArg1, TTrigger> setTriggerParameters(TTrigger trigger, Class<TArg0> classe0, Class<TArg1> classe1) {
        TriggerWithParameters2<TArg0, TArg1, TTrigger> configuration = new TriggerWithParameters2<TArg0, TArg1, TTrigger>(trigger, classe0, classe1);
        this.saveTriggerConfiguration(configuration);
        return configuration;
    }

    public <TArg0, TArg1, TArg2> TriggerWithParameters3<TArg0, TArg1, TArg2, TTrigger> setTriggerParameters(TTrigger trigger, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        TriggerWithParameters3<TArg0, TArg1, TArg2, TTrigger> configuration = new TriggerWithParameters3<TArg0, TArg1, TArg2, TTrigger>(trigger, classe0, classe1, classe2);
        this.saveTriggerConfiguration(configuration);
        return configuration;
    }

    public void generateDotFileInto(OutputStream dotFile) throws IOException {
        this.generateDotFileInto(dotFile, false);
    }

    public void generateDotFileInto(OutputStream dotFile, boolean printLabels) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(dotFile, "UTF-8");){
            PrintWriter writer = new PrintWriter(w);
            writer.write("digraph G {\n");
            for (Map.Entry<TState, StateRepresentation<TState, TTrigger>> entry : this.stateConfiguration.entrySet()) {
                Map<TTrigger, List<TriggerBehaviour<TState, TTrigger>>> behaviours = entry.getValue().getTriggerBehaviours();
                for (Map.Entry<TTrigger, List<TriggerBehaviour<TState, TTrigger>>> behaviour : behaviours.entrySet()) {
                    for (TriggerBehaviour<TState, TTrigger> triggerBehaviour : behaviour.getValue()) {
                        if (!(triggerBehaviour instanceof TransitioningTriggerBehaviour)) continue;
                        Object destination = triggerBehaviour.transitionsTo(null, null);
                        if (printLabels) {
                            writer.write(String.format("\t%s -> %s [label = \"%s\" ];\n", entry.getKey(), destination, triggerBehaviour.getTrigger()));
                            continue;
                        }
                        writer.write(String.format("\t%s -> %s;\n", entry.getKey(), destination));
                    }
                }
            }
            writer.write("}");
        }
    }
}

