/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.support;

import alluxio.shaded.client.com.google.protobuf.ByteString;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.Constants;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.stub.AbstractStub;
import alluxio.shaded.client.io.grpc.stub.MetadataUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;

public final class Util {
    private Util() {
    }

    public static List<URI> toURIs(Collection<String> uris) {
        return uris.stream().map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid endpoint URI: " + uri, e);
            }
        }).collect(Collectors.toList());
    }

    public static ByteString prefixNamespace(ByteSequence key, ByteSequence namespace) {
        return ByteString.copyFrom(namespace.isEmpty() ? key.getBytes() : namespace.concat(key).getBytes());
    }

    public static ByteString prefixNamespace(ByteString key, ByteSequence namespace) {
        return namespace.isEmpty() ? key : ByteString.copyFrom(namespace.concat(key).getBytes());
    }

    public static ByteString prefixNamespaceToRangeEnd(ByteSequence end, ByteSequence namespace) {
        if (namespace.isEmpty()) {
            return ByteString.copyFrom(end.getBytes());
        }
        if (end.size() == 1 && end.getBytes()[0] == 0) {
            byte[] prefixedEndArray = namespace.getBytes();
            boolean ok = false;
            for (int i = prefixedEndArray.length - 1; i >= 0; --i) {
                prefixedEndArray[i] = (byte)(prefixedEndArray[i] + 1);
                if (prefixedEndArray[i] == 0) continue;
                ok = true;
                break;
            }
            if (!ok) {
                prefixedEndArray = Constants.NULL_KEY.getBytes();
            }
            return ByteString.copyFrom(prefixedEndArray);
        }
        return ByteString.copyFrom(namespace.concat(end).getBytes());
    }

    public static ByteString prefixNamespaceToRangeEnd(ByteString end, ByteSequence namespace) {
        if (namespace.isEmpty()) {
            return end;
        }
        if (end.size() == 1 && end.toByteArray()[0] == 0) {
            byte[] prefixedEndArray = namespace.getBytes();
            boolean ok = false;
            for (int i = prefixedEndArray.length - 1; i >= 0; --i) {
                prefixedEndArray[i] = (byte)(prefixedEndArray[i] + 1);
                if (prefixedEndArray[i] == 0) continue;
                ok = true;
                break;
            }
            if (!ok) {
                prefixedEndArray = Constants.NULL_KEY.getBytes();
            }
            return ByteString.copyFrom(prefixedEndArray);
        }
        return ByteString.copyFrom(namespace.concat(end).getBytes());
    }

    public static ByteString unprefixNamespace(ByteString key, ByteSequence namespace) {
        return namespace.isEmpty() ? key : key.substring(namespace.size());
    }

    public static <T extends AbstractStub<T>> T applyRequireLeader(boolean requireLeader, T stub) {
        if (!requireLeader) {
            return stub;
        }
        Metadata md = new Metadata();
        md.put(Constants.REQUIRE_LEADER_KEY, "true");
        return stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(md));
    }

    public static ThreadFactory createThreadFactory(final String prefix, final boolean daemon) {
        final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = backingThreadFactory.newThread(r);
                t.setDaemon(daemon);
                t.setName(prefix + t.getName());
                return t;
            }
        };
    }
}

