/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.netty.handler.ssl;

import alluxio.shaded.client.io.netty.handler.ssl.OpenSslSession;
import alluxio.shaded.client.io.netty.handler.ssl.OpenSslSessionContext;
import alluxio.shaded.client.io.netty.handler.ssl.OpenSslSessionId;
import alluxio.shaded.client.io.netty.util.internal.EmptyArrays;
import alluxio.shaded.client.io.netty.util.internal.SuppressJava6Requirement;
import alluxio.shaded.client.javax.net.ssl.ExtendedSSLSession;
import alluxio.shaded.client.javax.net.ssl.SSLException;
import alluxio.shaded.client.javax.net.ssl.SSLPeerUnverifiedException;
import alluxio.shaded.client.javax.net.ssl.SSLSession;
import alluxio.shaded.client.javax.net.ssl.SSLSessionBindingEvent;
import alluxio.shaded.client.javax.net.ssl.SSLSessionBindingListener;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import javax.security.cert.X509Certificate;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
abstract class ExtendedOpenSslSession
extends ExtendedSSLSession
implements OpenSslSession {
    private static final String[] LOCAL_SUPPORTED_SIGNATURE_ALGORITHMS = new String[]{"SHA512withRSA", "SHA512withECDSA", "SHA384withRSA", "SHA384withECDSA", "SHA256withRSA", "SHA256withECDSA", "SHA224withRSA", "SHA224withECDSA", "SHA1withRSA", "SHA1withECDSA", "RSASSA-PSS"};
    private final OpenSslSession wrapped;

    ExtendedOpenSslSession(OpenSslSession wrapped) {
        this.wrapped = wrapped;
    }

    public abstract List getRequestedServerNames();

    public List<byte[]> getStatusResponses() {
        return Collections.emptyList();
    }

    @Override
    public OpenSslSessionId sessionId() {
        return this.wrapped.sessionId();
    }

    @Override
    public void setSessionId(OpenSslSessionId id) {
        this.wrapped.setSessionId(id);
    }

    @Override
    public final void setLocalCertificate(Certificate[] localCertificate) {
        this.wrapped.setLocalCertificate(localCertificate);
    }

    public String[] getPeerSupportedSignatureAlgorithms() {
        return EmptyArrays.EMPTY_STRINGS;
    }

    @Override
    public final void tryExpandApplicationBufferSize(int packetLengthDataOnly) {
        this.wrapped.tryExpandApplicationBufferSize(packetLengthDataOnly);
    }

    public final String[] getLocalSupportedSignatureAlgorithms() {
        return (String[])LOCAL_SUPPORTED_SIGNATURE_ALGORITHMS.clone();
    }

    public final byte[] getId() {
        return this.wrapped.getId();
    }

    @Override
    public final OpenSslSessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    public final long getCreationTime() {
        return this.wrapped.getCreationTime();
    }

    public final long getLastAccessedTime() {
        return this.wrapped.getLastAccessedTime();
    }

    public final void invalidate() {
        this.wrapped.invalidate();
    }

    public final boolean isValid() {
        return this.wrapped.isValid();
    }

    public final void putValue(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            value = new SSLSessionBindingListenerDecorator((SSLSessionBindingListener)value);
        }
        this.wrapped.putValue(name, value);
    }

    public final Object getValue(String s2) {
        Object value = this.wrapped.getValue(s2);
        if (value instanceof SSLSessionBindingListenerDecorator) {
            return ((SSLSessionBindingListenerDecorator)value).delegate;
        }
        return value;
    }

    public final void removeValue(String s2) {
        this.wrapped.removeValue(s2);
    }

    public final String[] getValueNames() {
        return this.wrapped.getValueNames();
    }

    public final Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.wrapped.getPeerCertificates();
    }

    public final Certificate[] getLocalCertificates() {
        return this.wrapped.getLocalCertificates();
    }

    public final X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return this.wrapped.getPeerCertificateChain();
    }

    public final Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.wrapped.getPeerPrincipal();
    }

    public final Principal getLocalPrincipal() {
        return this.wrapped.getLocalPrincipal();
    }

    public final String getCipherSuite() {
        return this.wrapped.getCipherSuite();
    }

    public String getProtocol() {
        return this.wrapped.getProtocol();
    }

    public final String getPeerHost() {
        return this.wrapped.getPeerHost();
    }

    public final int getPeerPort() {
        return this.wrapped.getPeerPort();
    }

    public final int getPacketBufferSize() {
        return this.wrapped.getPacketBufferSize();
    }

    public final int getApplicationBufferSize() {
        return this.wrapped.getApplicationBufferSize();
    }

    @Override
    public void handshakeFinished(byte[] id, String cipher, String protocol, byte[] peerCertificate, byte[][] peerCertificateChain, long creationTime, long timeout) throws SSLException {
        this.wrapped.handshakeFinished(id, cipher, protocol, peerCertificate, peerCertificateChain, creationTime, timeout);
    }

    public String toString() {
        return "ExtendedOpenSslSession{wrapped=" + this.wrapped + '}';
    }

    private final class SSLSessionBindingListenerDecorator
    implements SSLSessionBindingListener {
        final SSLSessionBindingListener delegate;

        SSLSessionBindingListenerDecorator(SSLSessionBindingListener delegate) {
            this.delegate = delegate;
        }

        public void valueBound(SSLSessionBindingEvent event) {
            this.delegate.valueBound(new SSLSessionBindingEvent((SSLSession)ExtendedOpenSslSession.this, event.getName()));
        }

        public void valueUnbound(SSLSessionBindingEvent event) {
            this.delegate.valueUnbound(new SSLSessionBindingEvent((SSLSession)ExtendedOpenSslSession.this, event.getName()));
        }
    }
}

