/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.http.impl;

import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.http.impl.ClientHttpEndpointBase;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpChannelConnector;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpClientConnection;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.impl.EventLoopContext;
import alluxio.shaded.client.io.vertx.core.spi.metrics.ClientMetrics;
import java.util.ArrayDeque;
import java.util.Deque;

class WebSocketEndpoint
extends ClientHttpEndpointBase<HttpClientConnection> {
    private final int maxPoolSize;
    private final HttpChannelConnector connector;
    private final Deque<Waiter> waiters;
    private int inflightConnections;

    WebSocketEndpoint(ClientMetrics metrics, int maxPoolSize, HttpChannelConnector connector, Runnable dispose) {
        super(metrics, dispose);
        this.maxPoolSize = maxPoolSize;
        this.connector = connector;
        this.waiters = new ArrayDeque<Waiter>();
    }

    private void tryConnect(ContextInternal ctx, final Handler<AsyncResult<HttpClientConnection>> handler) {
        EventLoopContext eventLoopContext = ctx instanceof EventLoopContext ? (EventLoopContext)ctx : ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        class Listener
        implements Handler<AsyncResult<HttpClientConnection>> {
            Listener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onEvict() {
                Waiter h2;
                WebSocketEndpoint.this.decRefCount();
                WebSocketEndpoint webSocketEndpoint = WebSocketEndpoint.this;
                synchronized (webSocketEndpoint) {
                    if (--WebSocketEndpoint.this.inflightConnections > WebSocketEndpoint.this.maxPoolSize || WebSocketEndpoint.this.waiters.isEmpty()) {
                        return;
                    }
                    h2 = (Waiter)WebSocketEndpoint.this.waiters.poll();
                }
                WebSocketEndpoint.this.tryConnect(h2.context, h2.handler);
            }

            @Override
            public void handle(AsyncResult<HttpClientConnection> ar) {
                if (ar.succeeded()) {
                    HttpClientConnection c = ar.result();
                    if (WebSocketEndpoint.this.incRefCount()) {
                        c.evictionHandler(v -> this.onEvict());
                        handler.handle(Future.succeededFuture(c));
                    } else {
                        c.close();
                        handler.handle(Future.failedFuture("Connection closed"));
                    }
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        }
        this.connector.httpConnect(eventLoopContext, new Listener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestConnection2(ContextInternal ctx, long timeout, Handler<AsyncResult<HttpClientConnection>> handler) {
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            if (this.inflightConnections >= this.maxPoolSize) {
                this.waiters.add(new Waiter(handler, ctx));
                return;
            }
            ++this.inflightConnections;
        }
        this.tryConnect(ctx, handler);
    }

    @Override
    void checkExpired() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            this.waiters.forEach(waiter -> waiter.context.runOnContext(v -> waiter.handler.handle(Future.failedFuture("Closed"))));
            this.waiters.clear();
        }
    }

    private static class Waiter {
        final Handler<AsyncResult<HttpClientConnection>> handler;
        final ContextInternal context;

        Waiter(Handler<AsyncResult<HttpClientConnection>> handler, ContextInternal context) {
            this.handler = handler;
            this.context = context;
        }
    }
}

