/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.evictor.CacheEvictorOptions;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;

@ThreadSafe
public class TwoChoiceRandomEvictor
implements CacheEvictor {
    private final Map<PageId, Long> mCache = Collections.synchronizedMap(new HashMap());

    public TwoChoiceRandomEvictor(CacheEvictorOptions options) {
    }

    @Override
    public void updateOnGet(PageId pageId) {
        this.mCache.put(pageId, Instant.now().toEpochMilli());
    }

    @Override
    public void updateOnPut(PageId pageId) {
        this.mCache.put(pageId, Instant.now().toEpochMilli());
    }

    @Override
    public void updateOnDelete(PageId pageId) {
        this.mCache.remove(pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PageId evict() {
        Map<PageId, Long> map = this.mCache;
        synchronized (map) {
            if (this.mCache.isEmpty()) {
                return null;
            }
            ArrayList<PageId> keys = new ArrayList<PageId>(this.mCache.keySet());
            Random rand = new Random();
            PageId key1 = (PageId)keys.get(rand.nextInt(keys.size()));
            PageId key2 = (PageId)keys.get(rand.nextInt(keys.size()));
            if (this.mCache.get(key1) < this.mCache.get(key2)) {
                return key1;
            }
            return key2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PageId evictMatching(Predicate<PageId> criterion) {
        Map<PageId, Long> map = this.mCache;
        synchronized (map) {
            for (PageId candidate : this.mCache.keySet()) {
                if (!criterion.test(candidate)) continue;
                return candidate;
            }
            return null;
        }
    }

    @Override
    public void reset() {
        this.mCache.clear();
    }
}

