/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.com.google.common.hash.HashCode;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerIdentity;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

@VisibleForTesting
@ThreadSafe
public class MaglevHashProvider {
    private final int mMaxAttempts;
    private final long mWorkerInfoUpdateIntervalNs;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();
    private final AtomicLong mLastUpdatedTimestamp = new AtomicLong(System.nanoTime());
    private final LongAdder mUpdateCount = new LongAdder();
    private final AtomicReference<Set<WorkerIdentity>> mLastWorkers = new AtomicReference(ImmutableSet.of());
    private final Object mInitLock = new Object();
    private static final int INDEX_SEED = -559038737;
    private final int mLookupSize;
    private WorkerIdentity[] mLookup;
    private Map<WorkerIdentity, Permutation> mPermutations;

    public MaglevHashProvider(int maxAttempts, long workerListTtlMs, int lookupSize) {
        this.mMaxAttempts = maxAttempts;
        this.mWorkerInfoUpdateIntervalNs = workerListTtlMs * 1000000L;
        this.mLookupSize = lookupSize;
        this.mPermutations = new HashMap<WorkerIdentity, Permutation>();
    }

    public List<WorkerIdentity> getMultiple(String key, int count) {
        LinkedHashSet<WorkerIdentity> workers = new LinkedHashSet<WorkerIdentity>();
        int attempts = 0;
        while (workers.size() < count && attempts < this.mMaxAttempts) {
            WorkerIdentity selectedWorker = this.get(key, ++attempts);
            workers.add(selectedWorker);
        }
        return ImmutableList.copyOf(workers);
    }

    public void refresh(Set<WorkerIdentity> workers) {
        Set<WorkerIdentity> lastWorkerIds;
        Preconditions.checkArgument(!workers.isEmpty(), "cannot refresh hash provider with empty worker list");
        this.maybeInitialize(workers);
        if (this.shouldRebuildActiveNodesMapExclusively() && !workers.equals(lastWorkerIds = this.mLastWorkers.get())) {
            this.updateActiveNodes(workers, this.mLastWorkers.get());
            this.mLastWorkers.set(workers);
            this.mUpdateCount.increment();
        }
    }

    private boolean shouldRebuildActiveNodesMapExclusively() {
        long lastUpdateTs = this.mLastUpdatedTimestamp.get();
        long currentTs = System.nanoTime();
        if (currentTs - lastUpdateTs > this.mWorkerInfoUpdateIntervalNs) {
            return this.mLastUpdatedTimestamp.compareAndSet(lastUpdateTs, currentTs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitialize(Set<WorkerIdentity> workers) {
        if (this.mLookup == null) {
            Object object = this.mInitLock;
            synchronized (object) {
                if (this.mLookup == null) {
                    this.build(workers);
                    this.mLastWorkers.set(workers);
                    this.mLastUpdatedTimestamp.set(System.nanoTime());
                }
            }
        }
    }

    private void updateActiveNodes(Set<WorkerIdentity> workers, Set<WorkerIdentity> lastWorkers) {
        HashSet<WorkerIdentity> workerSet = new HashSet<WorkerIdentity>(workers);
        HashSet<WorkerIdentity> lastWorkerSet = new HashSet<WorkerIdentity>(lastWorkers);
        HashSet<WorkerIdentity> toRemove = new HashSet<WorkerIdentity>();
        HashSet<WorkerIdentity> toAdd = new HashSet<WorkerIdentity>();
        for (WorkerIdentity worker : lastWorkerSet) {
            if (workerSet.contains(worker)) continue;
            toRemove.add(worker);
        }
        for (WorkerIdentity worker : workerSet) {
            if (lastWorkerSet.contains(worker)) continue;
            toAdd.add(worker);
        }
        this.remove(toRemove);
        this.add(toAdd);
    }

    @VisibleForTesting
    WorkerIdentity get(String key, int index) {
        Preconditions.checkState(this.mLookup != null, "Hash provider is not properly initialized");
        if (this.mLookup.length == 0) {
            return null;
        }
        int id = Math.abs(this.hash(String.format("%s%d%d", key, index, -559038737)) % this.mLookup.length);
        return this.mLookup[id];
    }

    @VisibleForTesting
    long getUpdateCount() {
        return this.mUpdateCount.sum();
    }

    @VisibleForTesting
    private void build(Set<WorkerIdentity> workers) {
        Preconditions.checkArgument(!workers.isEmpty(), "worker list is empty");
        this.mLookup = new WorkerIdentity[0];
        this.add(workers);
    }

    private void add(Set<WorkerIdentity> toAdd) {
        this.mPermutations.values().forEach(Permutation::reset);
        for (WorkerIdentity backend : toAdd) {
            this.mPermutations.put(backend, this.newPermutation(backend));
        }
        this.mLookup = this.newLookup();
    }

    private void remove(Collection<WorkerIdentity> toRemove) {
        toRemove.forEach(this.mPermutations::remove);
        this.mPermutations.values().forEach(Permutation::reset);
        this.mLookup = this.newLookup();
    }

    int hash(String key) {
        return HASH_FUNCTION.hashString(key, StandardCharsets.UTF_8).asInt();
    }

    private Permutation newPermutation(WorkerIdentity backend) {
        return new Permutation(backend, this.mLookupSize);
    }

    private WorkerIdentity[] newLookup() {
        WorkerIdentity[] lookup = new WorkerIdentity[this.mLookupSize];
        AtomicInteger filled = new AtomicInteger();
        do {
            this.mPermutations.values().forEach(permutation -> {
                int pos = permutation.next();
                if (lookup[pos] == null) {
                    lookup[pos] = permutation.backend();
                }
            });
        } while (filled.incrementAndGet() < this.mLookupSize);
        return lookup;
    }

    class Permutation {
        private static final int OFFSET_SEED = -559039810;
        private static final int SKIP_SEED = -559030611;
        private final WorkerIdentity mBackend;
        private final int mSize;
        private final int mOffset;
        private final int mSkip;
        private int mCurrent;

        int hash1(String key) {
            return HASH_FUNCTION.hashString(key, StandardCharsets.UTF_8).asInt();
        }

        int hash2(String key) {
            return alluxio.shaded.client.org.apache.curator.shaded.com.google.common.hash.Hashing.crc32c().hashString(key, StandardCharsets.UTF_8).asInt();
        }

        Permutation(WorkerIdentity backend, int size) {
            this.mSize = size;
            this.mBackend = backend;
            HashCode hashCode = HASH_FUNCTION.newHasher().putObject(backend, WorkerIdentity.HashFunnel.INSTANCE).hash();
            this.mOffset = this.hash1(String.format("%d%d", hashCode.asInt(), -559039810)) % size;
            this.mSkip = this.hash2(String.format("%d%d", hashCode.asInt(), -559030611)) % (size - 1) + 1;
            this.mCurrent = this.mOffset;
        }

        WorkerIdentity backend() {
            return this.mBackend;
        }

        int next() {
            this.mCurrent = (this.mCurrent + this.mSkip) % this.mSize;
            return Math.abs(this.mCurrent);
        }

        void reset() {
            this.mCurrent = this.mOffset;
        }
    }
}

