/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.dora.WorkerLocationPolicyEnum;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.membership.WorkerClusterView;
import alluxio.util.CommonUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface WorkerLocationPolicy {
    public List<BlockWorkerInfo> getPreferredWorkers(WorkerClusterView var1, String var2, int var3) throws ResourceExhaustedException;

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        private Factory() {
        }

        public static WorkerLocationPolicy create(AlluxioConfiguration conf) {
            try {
                String policyName = (String)conf.get(PropertyKey.USER_WORKER_SELECTION_POLICY);
                WorkerLocationPolicyEnum policyEnum = WorkerLocationPolicyEnum.valueOf(policyName.toUpperCase());
                Class<?> policyClass = Class.forName(policyEnum.getPolicyName());
                WorkerLocationPolicy workerLocationPolicy = (WorkerLocationPolicy)CommonUtils.createNewClassInstance(policyClass, new Class[]{AlluxioConfiguration.class}, new Object[]{conf});
                LOG.debug("Using worker location policy: {}", (Object)workerLocationPolicy.getClass().getSimpleName());
                return workerLocationPolicy;
            }
            catch (ClassCastException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

