/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.netty;

import alluxio.network.netty.NettyRPCContext;
import alluxio.network.protocol.RPCProtoMessage;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.ChannelFuture;
import alluxio.shaded.client.io.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.io.netty.channel.ChannelInboundHandlerAdapter;
import alluxio.shaded.client.io.netty.util.concurrent.Future;
import alluxio.shaded.client.io.netty.util.concurrent.GenericFutureListener;
import alluxio.shaded.client.io.netty.util.concurrent.Promise;
import alluxio.util.CommonUtils;
import alluxio.util.proto.ProtoMessage;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NettyRPC {
    private NettyRPC() {
    }

    public static ProtoMessage call(NettyRPCContext context, ProtoMessage request) throws IOException {
        ProtoMessage message;
        Channel channel = Preconditions.checkNotNull(context.getChannel());
        Promise<ProtoMessage> promise = channel.eventLoop().newPromise();
        channel.pipeline().addLast(new RPCHandler(promise));
        channel.writeAndFlush(new RPCProtoMessage(request)).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> {
            if (future.cause() != null) {
                future.channel().close();
                promise.tryFailure(future.cause());
            }
        }));
        try {
            message = (ProtoMessage)promise.get(context.getTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            CommonUtils.closeChannel(channel);
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            CommonUtils.closeChannel(channel);
            throw new RuntimeException(e);
        }
        finally {
            if (channel.isOpen()) {
                channel.pipeline().removeLast();
            }
        }
        if (message.isResponse()) {
            CommonUtils.unwrapResponseFrom(message.asResponse(), context.getChannel());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireAndForget(NettyRPCContext context, ProtoMessage request) throws IOException {
        Channel channel = Preconditions.checkNotNull(context.getChannel());
        AtomicBoolean flushed = new AtomicBoolean(false);
        channel.writeAndFlush(new RPCProtoMessage(request)).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> {
            if (future.cause() != null) {
                future.channel().close();
            }
            AtomicBoolean atomicBoolean = flushed;
            synchronized (atomicBoolean) {
                flushed.set(true);
                flushed.notifyAll();
            }
        }));
        try {
            AtomicBoolean atomicBoolean = flushed;
            synchronized (atomicBoolean) {
                while (!flushed.get()) {
                    flushed.wait();
                }
            }
        }
        catch (InterruptedException e) {
            CommonUtils.closeChannel(channel);
            throw new RuntimeException(e);
        }
    }

    public static class RPCHandler
    extends ChannelInboundHandlerAdapter {
        private final Promise<ProtoMessage> mPromise;

        public RPCHandler(Promise<ProtoMessage> promise) {
            this.mPromise = promise;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (!this.acceptMessage(msg)) {
                ctx.fireChannelRead(msg);
                return;
            }
            ProtoMessage message = ((RPCProtoMessage)msg).getMessage();
            this.mPromise.trySuccess(message);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.mPromise.tryFailure(cause);
            ctx.close();
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) {
            this.mPromise.tryFailure(new IOException("ChannelClosed"));
            ctx.fireChannelUnregistered();
        }

        protected boolean acceptMessage(Object msg) {
            return msg instanceof RPCProtoMessage;
        }
    }
}

