/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.resolver;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.etcd.jetcd.common.exception.ErrorCode;
import alluxio.shaded.client.io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.EquivalentAddressGroup;
import alluxio.shaded.client.io.grpc.NameResolver;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.internal.GrpcUtil;
import alluxio.shaded.client.io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNameResolver
extends NameResolver {
    public static final int ETCD_CLIENT_PORT = 2379;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNameResolver.class);
    private final Object lock = new Object();
    private final String authority;
    private final URI targetUri;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    private Executor executor;
    private NameResolver.Listener listener;

    public AbstractNameResolver(URI targetUri) {
        this.targetUri = targetUri;
        this.authority = targetUri.getAuthority() != null ? targetUri.getAuthority() : "";
    }

    public URI getTargetUri() {
        return this.targetUri;
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.listener == null, "already started");
            this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = Preconditions.checkNotNull(listener, "listener");
            this.resolve();
        }
    }

    @Override
    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            List<EquivalentAddressGroup> groups = this.computeAddressGroups();
            if (groups.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoint " + this.targetUri);
            }
            savedListener.onAddresses(groups, Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }

    protected abstract List<EquivalentAddressGroup> computeAddressGroups();
}

